<?php include __DIR__ . '/../layout/header.php'; ?>

<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-building"></i> <?= Helper::escape($supplier['supplier_name']) ?></h2>
    <div class="btn-group">
        <a href="<?= BASE_URL ?>/suppliers/edit/<?= $supplier['id'] ?>" class="btn btn-warning">
            <i class="fas fa-edit"></i> Düzenle
        </a>
        <a href="<?= BASE_URL ?>/suppliers" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Geri
        </a>
    </div>
</div>

<!-- Balance Summary Cards -->
<div class="row mb-4">
    <div class="col-md-4">
        <div class="card bg-primary text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-shopping-cart"></i> Toplam Alımlar</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($balance['total_purchases']) ?></h3>
                <small><?= $balance['transaction_count'] ?> işlem</small>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-success text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-hand-holding-usd"></i> Toplam Ödemeler</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($balance['total_payments']) ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card bg-<?= $balance['balance'] > 0 ? 'danger' : 'secondary' ?> text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-balance-scale"></i> Kalan Borç</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($balance['balance']) ?></h3>
            </div>
        </div>
    </div>
</div>

<!-- Transaction List -->
<div class="card mb-4">
    <div class="card-header bg-white">
        <h5 class="mb-0"><i class="fas fa-list"></i> İşlem Geçmişi (<?= count($transactions) ?> kayıt)</h5>
    </div>
    <div class="card-body">
        <?php if (empty($transactions)): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i> Henüz işlem kaydı yok. Aşağıdaki formu kullanarak yeni işlem ekleyebilirsiniz.
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Tarih</th>
                            <th>İşlem Tipi</th>
                            <th>Referans</th>
                            <th>Açıklama</th>
                            <th class="text-end">Tutar</th>
                            <th class="text-center">İşlem</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($transactions as $trans): ?>
                            <tr>
                                <td>
                                    <i class="fas fa-calendar text-muted"></i>
                                    <?= Helper::formatDate($trans['transaction_date']) ?>
                                </td>
                                <td>
                                    <span class="badge bg-<?= getTransactionBadge($trans['transaction_type']) ?>">
                                        <?= translateTransactionType($trans['transaction_type']) ?>
                                    </span>
                                </td>
                                <td><?= Helper::escape($trans['reference_number'] ?? '-') ?></td>
                                <td>
                                    <?= Helper::escape($trans['description'] ?? '-') ?>
                                    <?php if (!empty($trans['check_id'])): ?>
                                        <div class="mt-1">
                                            <span class="badge bg-dark">Cek</span>
                                            <small class="text-muted">
                                                No: <?= Helper::escape($trans['check_number']) ?>
                                                <?php if (!empty($trans['check_due_date'])): ?>
                                                    | Vade: <?= Helper::formatDate($trans['check_due_date']) ?>
                                                <?php endif; ?>
                                            </small>
                                            <?php if (($trans['check_status'] ?? '') === 'TAHSIL_EDILDI'): ?>
                                                <span class="badge bg-success">Tahsil Edildi</span>
                                            <?php else: ?>
                                                <span class="badge bg-warning text-dark">Beklemede</span>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td class="text-end fw-bold <?= in_array($trans['transaction_type'], ['payment', 'refund']) ? 'text-success' : 'text-danger' ?>">
                                    <?= in_array($trans['transaction_type'], ['payment', 'refund']) ? '-' : '+' ?>
                                    <?= Helper::formatMoney($trans['amount']) ?>
                                </td>
                                <td class="text-center">
                                    <button type="button" class="btn btn-sm btn-danger"
                                            data-bs-toggle="modal"
                                            data-bs-target="#deleteTransModal<?= $trans['id'] ?>"
                                            title="İşlemi Sil">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>

                            <!-- Delete Modal for each transaction -->
                            <div class="modal fade" id="deleteTransModal<?= $trans['id'] ?>" tabindex="-1" aria-labelledby="deleteTransModalLabel<?= $trans['id'] ?>" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="deleteTransModalLabel<?= $trans['id'] ?>">
                                                <i class="fas fa-exclamation-triangle text-warning"></i> İşlemi Sil
                                            </h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            <p>Bu işlemi silmek istediğinizden emin misiniz?</p>
                                            <div class="alert alert-warning mb-0">
                                                <small>
                                                    <strong>İşlem Detayı:</strong><br>
                                                    Tip: <?= translateTransactionType($trans['transaction_type']) ?><br>
                                                    Tutar: <?= Helper::formatMoney($trans['amount']) ?><br>
                                                    Tarih: <?= Helper::formatDate($trans['transaction_date']) ?>
                                                </small>
                                            </div>
                                            <p class="text-danger mt-2 mb-0"><small><i class="fas fa-info-circle"></i> Bu işlem geri alınamaz ve bakiye yeniden hesaplanacaktır!</small></p>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                                <i class="fas fa-times"></i> İptal
                                            </button>
                                            <form method="POST" action="<?= BASE_URL ?>/suppliers/delete-transaction/<?= $supplier['id'] ?>/<?= $trans['id'] ?>" class="d-inline">
                                                <button type="submit" class="btn btn-danger">
                                                    <i class="fas fa-trash"></i> Sil
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Add New Transaction Form -->
<div class="card">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0"><i class="fas fa-plus-circle"></i> Yeni İşlem Ekle</h5>
    </div>
    <div class="card-body">
        <form method="POST" action="<?= BASE_URL ?>/suppliers/save-transaction/<?= $supplier['id'] ?>">
            <div class="row">
                <div class="col-md-2">
                    <div class="mb-3">
                        <label for="transaction_type" class="form-label">İşlem Tipi <span class="text-danger">*</span></label>
                        <select class="form-select" id="transaction_type" name="transaction_type" required>
                            <option value="">Seçiniz...</option>
                            <option value="purchase">🛒 Alım (Borç Artar)</option>
                            <option value="payment">💰 Ödeme (Borç Azalır)</option>
                            <option value="refund">↩️ İade (Borç Azalır)</option>
                            <option value="adjustment">⚙️ Düzeltme</option>
                        </select>
                    </div>
                </div>

                <div class="col-md-2">
                    <div class="mb-3">
                        <label for="payment_method" class="form-label">Odeme Yontemi</label>
                        <select class="form-select" id="payment_method" name="payment_method">
                            <option value="cash">Nakit</option>
                            <option value="eft">EFT/Havale</option>
                            <option value="check">Cek</option>
                        </select>
                    </div>
                </div>

                <div class="col-md-2">
                    <div class="mb-3">
                        <label for="amount" class="form-label">Tutar (₺) <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" class="form-control" id="amount"
                               name="amount" required min="0.01" placeholder="0.00">
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="transaction_date" class="form-label">Tarih <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" id="transaction_date"
                               name="transaction_date" value="<?= date('Y-m-d') ?>" required>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="reference_number" class="form-label">Referans No</label>
                        <input type="text" class="form-control" id="reference_number"
                               name="reference_number" placeholder="Fatura/Makbuz No">
                    </div>
                </div>
            </div>

            <div class="row d-none" id="checkFieldsRow">
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="check_number" class="form-label">Cek No <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" id="check_number" name="check_number" placeholder="Cek numarasi">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="check_bank_name" class="form-label">Cek Bankasi</label>
                        <input type="text" class="form-control" id="check_bank_name" name="check_bank_name" placeholder="Banka adi">
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="check_due_date" class="form-label">Cek Vade Tarihi <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" id="check_due_date" name="check_due_date">
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <label for="description" class="form-label">Açıklama</label>
                <textarea class="form-control" id="description" name="description"
                          rows="2" placeholder="Ne alındı? Neden ödendi? (Opsiyonel)"></textarea>
            </div>

            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> İşlemi Kaydet
            </button>
        </form>
    </div>
</div>

<?php
/**
 * Helper functions for this view
 */
function getTransactionBadge($type) {
    switch ($type) {
        case 'purchase': return 'primary';
        case 'payment': return 'success';
        case 'refund': return 'warning';
        case 'adjustment': return 'secondary';
        default: return 'secondary';
    }
}

function translateTransactionType($type) {
    switch ($type) {
        case 'purchase': return 'Alım';
        case 'payment': return 'Ödeme';
        case 'refund': return 'İade';
        case 'adjustment': return 'Düzeltme';
        default: return $type;
    }
}
?>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const typeEl = document.getElementById('transaction_type');
    const methodEl = document.getElementById('payment_method');
    const checkRow = document.getElementById('checkFieldsRow');
    const checkNo = document.getElementById('check_number');
    const checkDue = document.getElementById('check_due_date');

    function updateCheckFields() {
        const isPayment = typeEl.value === 'payment';
        methodEl.disabled = !isPayment;
        if (!isPayment) {
            methodEl.value = 'cash';
        }

        const isCheck = isPayment && methodEl.value === 'check';
        checkRow.classList.toggle('d-none', !isCheck);
        checkNo.required = isCheck;
        checkDue.required = isCheck;
    }

    typeEl.addEventListener('change', updateCheckFields);
    methodEl.addEventListener('change', updateCheckFields);
    updateCheckFields();
});
</script>

<?php include __DIR__ . '/../layout/footer.php'; ?>
