<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-plus-circle"></i> Yeni Alınan Çek</h2>
    <a href="<?= BASE_URL ?>/received-checks" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Geri Dön
    </a>
</div>

<div class="card glass-card">
    <div class="card-body">
        <form method="POST" action="<?= BASE_URL ?>/received-checks/store">
            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="customer_name" class="form-label">Müşteri Adı <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="customer_name" name="customer_name" required>
                </div>

                <div class="col-md-6 mb-3">
                    <label for="amount" class="form-label">Tutar (TL) <span class="text-danger">*</span></label>
                    <input type="number" step="0.01" class="form-control" id="amount" name="amount" required>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="bank_name" class="form-label">Banka Adı</label>
                    <input type="text" class="form-control" id="bank_name" name="bank_name"
                        placeholder="Örn: Ziraat Bankası">
                </div>

                <div class="col-md-6 mb-3">
                    <label for="check_number" class="form-label">Çek Numarası</label>
                    <input type="text" class="form-control" id="check_number" name="check_number">
                </div>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label for="due_date" class="form-label">Vade Tarihi <span class="text-danger">*</span></label>
                    <input type="date" class="form-control" id="due_date" name="due_date" required>
                </div>
            </div>

            <div class="mb-3">
                <label for="description" class="form-label">Açıklama</label>
                <textarea class="form-control" id="description" name="description" rows="3"></textarea>
            </div>

            <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                <a href="<?= BASE_URL ?>/received-checks" class="btn btn-secondary">
                    <i class="fas fa-times"></i> İptal
                </a>
                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-save"></i> Kaydet
                </button>
            </div>
        </form>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>