<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="mb-3">
    <a href="<?= BASE_URL ?>/personnel-attendance?month=<?= $year ?>-<?= str_pad($month, 2, '0', STR_PAD_LEFT) ?>" class="btn btn-outline-secondary">
        <i class="fas fa-arrow-left"></i> Geri
    </a>
</div>

<h2><i class="fas fa-id-card"></i> Puantaj Kartı</h2>
<p class="text-muted"><?= Helper::escape($personnel['full_name']) ?> - <?= $monthName ?> <?= $year ?></p>

<div class="card">
    <div class="card-body">
        <div class="alert alert-info">
            <i class="fas fa-info-circle"></i> Aşağıdaki metni kopyalayıp WhatsApp'tan gönderebilirsiniz
        </div>

        <div class="position-relative">
            <button class="btn btn-success position-absolute top-0 end-0" onclick="copyToClipboard()" style="z-index: 10;">
                <i class="fas fa-copy"></i> Kopyala
            </button>

            <pre id="whatsappCard" class="bg-light p-4 rounded" style="font-family: monospace; white-space: pre-wrap; line-height: 1.6;">┏━━━━━━━━━━━━━━━━━━━━━━━━┓
┃  📋 PUANTAJ KARTI       ┃
┗━━━━━━━━━━━━━━━━━━━━━━━━┛

👤 Personel: <?= Helper::escape($personnel['full_name']) ?>

📅 Dönem: <?= $monthName ?> <?= $year ?>


━━━━━━━━━━━━━━━━━━━━━━━━
  📊 ÇALIŞMA BİLGİLERİ
━━━━━━━━━━━━━━━━━━━━━━━━

✅ Çalışan Gün      : <?= str_pad(number_format($attendance['calisan_gun'] ?? 0, 1), 6, ' ', STR_PAD_LEFT) ?> gün
🏖️ Yıllık İzin      : <?= str_pad(number_format($attendance['yillik_izin'] ?? 0, 1), 6, ' ', STR_PAD_LEFT) ?> gün
☀️ Pazar Günü       : <?= str_pad(number_format($attendance['pazar_gun'] ?? 0, 1), 6, ' ', STR_PAD_LEFT) ?> gün

━━━━━━━━━━━━━━━━━━━━━━━━
  ⏰ EK MESAİ
━━━━━━━━━━━━━━━━━━━━━━━━

⚡ Gün Aşırı Mesai  : <?= str_pad(number_format($attendance['gun_asiri_ek_mesai'] ?? 0, 1), 6, ' ', STR_PAD_LEFT) ?> gün
☀️ Pazar Mesai      : <?= str_pad(number_format($attendance['pazar_ek_mesai'] ?? 0, 1), 6, ' ', STR_PAD_LEFT) ?> gün
🎉 Resmi Tatil      : <?= str_pad(number_format($attendance['resmi_tatil_mesai'] ?? 0, 1), 6, ' ', STR_PAD_LEFT) ?> gün

━━━━━━━━━━━━━━━━━━━━━━━━
  💼 İLAVELER
━━━━━━━━━━━━━━━━━━━━━━━━

🍽️ Yemek Gün       : <?= str_pad(number_format($attendance['yemek_gun'] ?? 0, 1), 6, ' ', STR_PAD_LEFT) ?> gün
🚗 İl Dışı Gün      : <?= str_pad(number_format($attendance['ildisi_gun'] ?? 0, 1), 6, ' ', STR_PAD_LEFT) ?> gün
💰 Cep Masraf       : <?= str_pad(number_format($attendance['cep_masraf'] ?? 0, 2), 10, ' ', STR_PAD_LEFT) ?> ₺

━━━━━━━━━━━━━━━━━━━━━━━━

📌 Bu bilgiler <?= date('d.m.Y H:i') ?> tarihinde
   sistem üzerinden alınmıştır.

━━━━━━━━━━━━━━━━━━━━━━━━</pre>
        </div>
    </div>
</div>

<script>
function copyToClipboard() {
    const text = document.getElementById('whatsappCard').innerText;

    if (navigator.clipboard && navigator.clipboard.writeText) {
        navigator.clipboard.writeText(text).then(() => {
            alert('✅ Puantaj kartı kopyalandı! WhatsApp\'a yapıştırabilirsiniz.');
        }).catch(err => {
            fallbackCopy(text);
        });
    } else {
        fallbackCopy(text);
    }
}

function fallbackCopy(text) {
    const textarea = document.createElement('textarea');
    textarea.value = text;
    textarea.style.position = 'fixed';
    textarea.style.opacity = '0';
    document.body.appendChild(textarea);
    textarea.select();

    try {
        document.execCommand('copy');
        alert('✅ Puantaj kartı kopyalandı! WhatsApp\'a yapıştırabilirsiniz.');
    } catch (err) {
        alert('❌ Kopyalama başarısız. Lütfen manuel olarak seçip kopyalayın.');
    }

    document.body.removeChild(textarea);
}
</script>

<?php include __DIR__ . '/../layout/footer.php'; ?>
