<?php include __DIR__ . '/../layout/header.php'; ?>

<?php
// Seçili ayın bilgilerini hesapla
$selectedMonth = $_GET['month'] ?? date('Y-m');
list($selectedYear, $selectedMonthNum) = explode('-', $selectedMonth);
$totalDays = cal_days_in_month(CAL_GREGORIAN, $selectedMonthNum, $selectedYear);
$sundays = 0;
for ($day = 1; $day <= $totalDays; $day++) {
    if (date('w', strtotime("$selectedYear-$selectedMonthNum-$day")) == 0) {
        $sundays++;
    }
}
$monthName = ['','Ocak','Şubat','Mart','Nisan','Mayıs','Haziran','Temmuz','Ağustos','Eylül','Ekim','Kasım','Aralık'][(int)$selectedMonthNum];
?>

<div class="d-flex justify-content-between align-items-center mb-3">
    <h2><i class="fas fa-clipboard-check"></i> Personel Puantaj</h2>
    <div class="d-flex gap-2">
        <input type="month" class="form-control" id="monthSelector" value="<?= $selectedMonth ?>"
               onchange="window.location.href='<?= BASE_URL ?>/personnel-attendance?month=' + this.value"
               style="width: 200px;">
        <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#addAttendanceModal">
            <i class="fas fa-plus"></i> Puantaj Ekle
        </button>
    </div>
</div>

<div class="alert alert-info mb-3">
    <i class="fas fa-info-circle"></i>
    <strong><?= $monthName ?> <?= $selectedYear ?></strong> ayında toplam <strong><?= $totalDays ?> gün</strong> var,
    bunun <strong><?= $sundays ?> günü Pazar</strong>. (Çalışma günü: <strong><?= $totalDays - $sundays ?> gün</strong>)
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-hover">
                <thead class="table-light">
                    <tr>
                        <th rowspan="2" class="align-middle">Personel Adı</th>
                        <th colspan="3" class="text-center bg-info bg-opacity-10">Çalışma</th>
                        <th colspan="3" class="text-center bg-warning bg-opacity-10">Ek Mesai</th>
                        <th colspan="3" class="text-center bg-success bg-opacity-10">İlaveler</th>
                        <th rowspan="2" class="align-middle">İşlemler</th>
                    </tr>
                    <tr>
                        <th class="bg-info bg-opacity-10">Çalışan Gün</th>
                        <th class="bg-info bg-opacity-10">Yıllık İzin</th>
                        <th class="bg-info bg-opacity-10">Pazar Günü</th>
                        <th class="bg-warning bg-opacity-10">Gün Aşırı</th>
                        <th class="bg-warning bg-opacity-10">Pazar Mesai</th>
                        <th class="bg-warning bg-opacity-10">Resmi Tatil</th>
                        <th class="bg-success bg-opacity-10">Yemek Gün</th>
                        <th class="bg-success bg-opacity-10">İl Dışı</th>
                        <th class="bg-success bg-opacity-10">Cep Masraf</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($personnel)): ?>
                    <tr><td colspan="10" class="text-center">Personel kaydı bulunamadı</td></tr>
                    <?php else: ?>
                        <?php foreach ($personnel as $p): ?>
                        <tr>
                            <td><strong><?= Helper::escape($p['full_name']) ?></strong></td>
                            <td><?= ($p['calisan_gun'] ?? 0) ?: '-' ?></td>
                            <td><?= ($p['yillik_izin'] ?? 0) ?: '-' ?></td>
                            <td><?= ($p['pazar_gun'] ?? 0) ?: '-' ?></td>
                            <td><?= ($p['gun_asiri_ek_mesai'] ?? 0) ?: '-' ?></td>
                            <td><?= ($p['pazar_ek_mesai'] ?? 0) ?: '-' ?></td>
                            <td><?= ($p['resmi_tatil_mesai'] ?? 0) ?: '-' ?></td>
                            <td><?= ($p['yemek_gun'] ?? 0) ?: '-' ?></td>
                            <td><?= ($p['ildisi_gun'] ?? 0) ?: '-' ?></td>
                            <td><?= ($p['cep_masraf'] ?? 0) ?: '-' ?></td>
                            <td>
                                <div class="btn-group" role="group">
                                    <button class="btn btn-sm btn-primary" onclick="editAttendance(<?= $p['id'] ?>, '<?= $selectedMonth ?>')">
                                        <i class="fas fa-edit"></i> Düzenle
                                    </button>
                                    <button class="btn btn-sm btn-success" onclick="viewCard(<?= $p['id'] ?>, '<?= $selectedMonth ?>')">
                                        <i class="fas fa-id-card"></i> Kart
                                    </button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Puantaj Ekleme Modal -->
<div class="modal fade" id="addAttendanceModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Puantaj Ekle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="<?= BASE_URL ?>/personnel-attendance/save">
                <div class="modal-body">
                    <div class="row mb-3">
                        <div class="col-md-8">
                            <label class="form-label">Personel</label>
                            <select class="form-select" name="personnel_id" required>
                                <?php foreach ($personnel as $p): ?>
                                <option value="<?= $p['id'] ?>"><?= Helper::escape($p['full_name']) ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Ay/Yıl</label>
                            <input type="month" class="form-control" name="period" value="<?= date('Y-m') ?>" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-2">
                            <label class="form-label">Çalışan Gün</label>
                            <input type="number" class="form-control" name="calisan_gun" step="0.5" value="0" min="0">
                        </div>
                        <div class="col-md-6 mb-2">
                            <label class="form-label">Yıllık İzin</label>
                            <input type="number" class="form-control" name="yillik_izin" step="0.5" value="0" min="0">
                        </div>
                        <div class="col-md-4 mb-2">
                            <label class="form-label">Gün Aşırı Ek Mesai</label>
                            <input type="number" class="form-control" name="gun_asiri_ek_mesai" step="0.5" value="0" min="0">
                        </div>
                        <div class="col-md-4 mb-2">
                            <label class="form-label">Pazar Ek Mesai</label>
                            <input type="number" class="form-control" name="pazar_ek_mesai" step="0.5" value="0" min="0">
                        </div>
                        <div class="col-md-4 mb-2">
                            <label class="form-label">Resmi Tatil Mesai</label>
                            <input type="number" class="form-control" name="resmi_tatil_mesai" step="0.5" value="0" min="0">
                        </div>
                        <div class="col-md-4 mb-2">
                            <label class="form-label">Yemek Gün</label>
                            <input type="number" class="form-control" name="yemek_gun" step="0.5" value="0" min="0">
                        </div>
                        <div class="col-md-4 mb-2">
                            <label class="form-label">İl Dışı-Gün</label>
                            <input type="number" class="form-control" name="ildisi_gun" step="0.5" value="0" min="0">
                        </div>
                        <div class="col-md-4 mb-2">
                            <label class="form-label">Cep Masraf</label>
                            <input type="number" class="form-control" name="cep_masraf" step="0.01" value="0" min="0">
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Kaydet</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function editAttendance(id, month) {
    window.location.href = '<?= BASE_URL ?>/personnel-attendance/edit?id=' + id + '&month=' + month;
}

function viewCard(id, month) {
    window.location.href = '<?= BASE_URL ?>/personnel-card?id=' + id + '&month=' + month;
}
</script>

<?php include __DIR__ . '/../layout/footer.php'; ?>
