<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-calendar-alt"></i> Aylık Ödemeler</h2>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPaymentModal">
        <i class="fas fa-plus"></i> Yeni Ödeme
    </button>
</div>

<div class="card">
    <div class="card-body">
        <?php if (empty($payments)): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i>
                Henüz aylık ödeme kaydı bulunmuyor.
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Ödeme Adı</th>
                            <th>Kategori</th>
                            <th>Ödeme Günü</th>
                            <th>Son Ödeme</th>
                            <th>Bu Ay Tutar</th>
                            <th>İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($payments as $payment): ?>
                        <tr>
                            <td><strong><?= Helper::escape($payment['payment_name']) ?></strong></td>
                            <td><span class="badge bg-secondary"><?= Helper::translateCategory($payment['category']) ?></span></td>
                            <td>Her ayın <?= $payment['payment_day'] ?>. günü</td>
                            <td><?= isset($payment['last_payment_date']) ? date('d.m.Y', strtotime($payment['last_payment_date'])) : '-' ?></td>
                            <td>
                                <button class="btn btn-sm btn-outline-primary" onclick="addPayment(<?= $payment['id'] ?>)">
                                    <i class="fas fa-plus-circle"></i> Tutar Ekle
                                </button>
                            </td>
                            <td>
                                <button class="btn btn-sm btn-info" onclick="viewHistory(<?= $payment['id'] ?>)">
                                    <i class="fas fa-history"></i> Geçmiş
                                </button>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Yeni Ödeme Modal -->
<div class="modal fade" id="addPaymentModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Yeni Aylık Ödeme</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="<?= BASE_URL ?>/monthly-payments/create">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Ödeme Adı</label>
                        <input type="text" class="form-control" name="payment_name" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Kategori</label>
                        <select class="form-select" name="category">
                            <option value="kdv">KDV</option>
                            <option value="sgk">SGK</option>
                            <option value="rent">Kira</option>
                            <option value="electricity">Elektrik</option>
                            <option value="water">Su</option>
                            <option value="gas">Doğalgaz</option>
                            <option value="phone">Telefon</option>
                            <option value="internet">İnternet</option>
                            <option value="salary">Maaş</option>
                            <option value="other">Diğer</option>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Ödeme Günü (1-31)</label>
                        <input type="number" class="form-control" name="payment_day" min="1" max="31" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Kaydet</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Tutar Ekleme Modal -->
<div class="modal fade" id="addAmountModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Ödeme Tutarı Ekle</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form id="addAmountForm">
                <div class="modal-body">
                    <input type="hidden" id="paymentId" name="paymentId">
                    <div class="mb-3">
                        <label class="form-label">Tutar (₺)</label>
                        <input type="number" class="form-control" id="amount" step="0.01" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Ödeme Tarihi</label>
                        <input type="date" class="form-control" id="paymentDate" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                    <button type="submit" class="btn btn-primary">Kaydet</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
let addAmountModal;

document.addEventListener('DOMContentLoaded', function() {
    addAmountModal = new bootstrap.Modal(document.getElementById('addAmountModal'));

    document.getElementById('addAmountForm').addEventListener('submit', function(e) {
        e.preventDefault();
        const id = document.getElementById('paymentId').value;
        const amount = document.getElementById('amount').value;
        const date = document.getElementById('paymentDate').value;
        window.location.href = `<?= BASE_URL ?>/monthly-payments/add-history?id=${id}&amount=${amount}&date=${date}`;
    });
});

function addPayment(paymentId) {
    document.getElementById('paymentId').value = paymentId;
    document.getElementById('paymentDate').value = new Date().toISOString().split('T')[0];
    document.getElementById('amount').value = '';
    addAmountModal.show();
}

function viewHistory(paymentId) {
    window.location.href = `<?= BASE_URL ?>/monthly-payments/history?id=${paymentId}`;
}
</script>

<?php include __DIR__ . '/../layout/footer.php'; ?>
