<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="mb-4">
    <a href="<?= BASE_URL ?>/monthly-payments" class="btn btn-outline-secondary">
        <i class="fas fa-arrow-left"></i> Geri
    </a>
</div>

<h2><i class="fas fa-history"></i> <?= Helper::escape($payment['payment_name']) ?> - Ödeme Geçmişi</h2>

<div class="card mt-3">
    <div class="card-body">
        <div class="row mb-4">
            <div class="col-md-4">
                <strong>Kategori:</strong> <?= Helper::translateCategory($payment['category']) ?>
            </div>
            <div class="col-md-4">
                <strong>Ödeme Günü:</strong> <?= $payment['payment_day'] ?>
            </div>
        </div>

        <?php if (empty($history)): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i>
                Henüz ödeme geçmişi bulunmuyor.
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Tarih</th>
                            <th>Tutar</th>
                            <th>Durum</th>
                            <th>Notlar</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($history as $h): ?>
                        <tr>
                            <td><?= date('d.m.Y', strtotime($h['payment_date'])) ?></td>
                            <td><strong><?= Helper::formatMoney($h['amount']) ?></strong></td>
                            <td>
                                <?php if ($h['status'] === 'paid'): ?>
                                    <span class="badge bg-success">Ödendi</span>
                                <?php elseif ($h['status'] === 'pending'): ?>
                                    <span class="badge bg-warning">Beklemede</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">İptal</span>
                                <?php endif; ?>
                            </td>
                            <td><?= Helper::escape($h['notes'] ?? '-') ?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
