<?php
/**
 * Modern Header - Responsive, Professional Theme
 */
?>
<!DOCTYPE html>
<html lang="tr">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? 'Dashboard' ?> - <?= APP_NAME ?></title>

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdn.jsdelivr.net/npm/@fortawesome/fontawesome-free@6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Glassmorphism Theme -->
    <link href="<?= BASE_URL ?>/assets/css/glassmorphism.css" rel="stylesheet">
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.0/dist/chart.umd.min.js"></script>

    <style>
        :root {
            --primary: #4F46E5;
            --primary-dark: #4338CA;
            --secondary: #10B981;
            --danger: #EF4444;
            --warning: #F59E0B;
            --info: #3B82F6;
            --dark: #1F2937;
            --light: #F9FAFB;
            --sidebar-width: 260px;
            --sidebar-collapsed: 70px;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, 'Segoe UI', sans-serif;
            background: var(--light);
            color: var(--dark);
            font-size: 14px;
        }

        /* Sidebar */
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            width: var(--sidebar-width);
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            box-shadow: 4px 0 20px rgba(102, 126, 234, 0.3);
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            z-index: 1000;
            overflow-y: auto;
            backdrop-filter: blur(10px);
        }

        .sidebar.collapsed {
            width: var(--sidebar-collapsed);
        }

        .sidebar::-webkit-scrollbar {
            width: 5px;
        }

        .sidebar::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.1);
        }

        .sidebar::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.3);
            border-radius: 10px;
        }

        .sidebar-header {
            padding: 24px 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255, 255, 255, 0.15);
            background: rgba(0, 0, 0, 0.15);
            backdrop-filter: blur(5px);
        }

        .sidebar-header h4 {
            color: white;
            font-weight: 700;
            font-size: 20px;
            margin: 0;
        }

        .sidebar-header small {
            color: rgba(255, 255, 255, 0.7);
            font-size: 12px;
        }

        .sidebar.collapsed .sidebar-header h4 {
            font-size: 18px;
        }

        .sidebar.collapsed .sidebar-header small {
            display: none;
        }

        .sidebar-user {
            padding: 15px 20px;
            background: rgba(0, 0, 0, 0.1);
            color: white;
        }

        .sidebar-user .user-name {
            font-weight: 600;
            font-size: 14px;
        }

        .sidebar-user .user-role {
            font-size: 11px;
            opacity: 0.7;
            text-transform: uppercase;
        }

        .sidebar.collapsed .sidebar-user {
            padding: 15px 10px;
            text-align: center;
        }

        .sidebar.collapsed .sidebar-user .user-name,
        .sidebar.collapsed .sidebar-user .user-role {
            display: none;
        }

        .sidebar-menu {
            padding: 10px 0;
        }

        .sidebar-menu a {
            display: flex;
            align-items: center;
            padding: 14px 20px;
            margin: 4px 12px;
            color: rgba(255, 255, 255, 0.85);
            text-decoration: none;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            position: relative;
            border-radius: 10px;
            font-weight: 500;
            font-size: 14px;
        }

        .sidebar-menu a::before {
            content: '';
            position: absolute;
            left: 0;
            top: 0;
            height: 100%;
            width: 0;
            background: rgba(255, 255, 255, 0.1);
            border-radius: 10px;
            transition: width 0.3s ease;
        }

        .sidebar-menu a:hover {
            background: rgba(255, 255, 255, 0.15);
            color: white;
            transform: translateX(4px);
        }

        .sidebar-menu a:hover::before {
            width: 100%;
        }

        .sidebar-menu a.active {
            background: linear-gradient(90deg, rgba(255,255,255,0.25), rgba(255,255,255,0.15));
            color: white;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
            border-left: 3px solid #10B981;
        }

        .sidebar-menu a.active i {
            color: #34D399;
        }

        .sidebar-menu a i {
            width: 22px;
            margin-right: 14px;
            text-align: center;
            font-size: 16px;
            transition: all 0.3s ease;
        }

        .sidebar-menu a:hover i {
            transform: scale(1.1);
        }

        .sidebar.collapsed .sidebar-menu a {
            justify-content: center;
            padding: 12px 10px;
        }

        .sidebar.collapsed .sidebar-menu a span {
            display: none;
        }

        .sidebar.collapsed .sidebar-menu a i {
            margin-right: 0;
        }

        /* Toggle Button */
        .sidebar-toggle {
            position: absolute;
            top: 15px;
            right: -15px;
            width: 30px;
            height: 30px;
            background: white;
            border: none;
            border-radius: 50%;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.2);
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
            color: var(--primary);
            transition: all 0.3s;
            z-index: 10;
            pointer-events: auto;
        }

        .sidebar-toggle:hover {
            transform: scale(1.1);
        }

        .sidebar-toggle:active {
            transform: scale(0.95);
        }

        /* Main Content */
        .main-content {
            margin-left: var(--sidebar-width);
            transition: all 0.3s ease;
            min-height: 100vh;
            padding: 20px;
        }

        .main-content.expanded {
            margin-left: var(--sidebar-collapsed);
        }

        /* Top Navbar */
        .top-navbar {
            background: white;
            padding: 15px 25px;
            border-radius: 12px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.08);
            margin-bottom: 25px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }

        .top-navbar h5 {
            margin: 0;
            font-weight: 600;
            color: var(--dark);
        }

        .top-navbar-right {
            display: flex;
            align-items: center;
            gap: 15px;
            color: #6B7280;
            font-size: 13px;
        }

        /* Cards */
        .card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.08);
            transition: all 0.3s;
        }

        .card:hover {
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.12);
            transform: translateY(-2px);
        }

        /* Stat Cards */
        .stat-card {
            padding: 20px;
            border-radius: 12px;
            background: white;
            position: relative;
            overflow: hidden;
        }

        .stat-card::before {
            content: '';
            position: absolute;
            top: 0;
            left: 0;
            width: 4px;
            height: 100%;
        }

        .stat-card.info::before {
            background: var(--info);
        }

        .stat-card.warning::before {
            background: var(--warning);
        }

        .stat-card.danger::before {
            background: var(--danger);
        }

        .stat-card.success::before {
            background: var(--secondary);
        }

        .stat-card h6 {
            color: #6B7280;
            font-size: 12px;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 0.5px;
            margin-bottom: 10px;
        }

        .stat-card h3 {
            color: var(--dark);
            font-weight: 700;
            font-size: 28px;
            margin-bottom: 5px;
        }

        .stat-card small {
            color: #9CA3AF;
            font-size: 12px;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }

            .sidebar.show {
                transform: translateX(0);
            }

            .main-content {
                margin-left: 0;
            }

            .sidebar-toggle {
                display: none;
            }
        }

        /* Mobile Menu Button */
        .mobile-menu-btn {
            display: none;
            position: fixed;
            bottom: 20px;
            right: 20px;
            width: 60px;
            height: 60px;
            background: var(--primary);
            color: white;
            border: none;
            border-radius: 50%;
            box-shadow: 0 4px 15px rgba(79, 70, 229, 0.4);
            z-index: 999;
            cursor: pointer;
        }

        @media (max-width: 768px) {
            .mobile-menu-btn {
                display: block;
            }
        }
    </style>
</head>

<body>
    <!-- Sidebar -->
    <nav class="sidebar" id="sidebar">
        <button class="sidebar-toggle" onclick="toggleSidebar()">
            <i class="fas fa-chevron-left"></i>
        </button>

        <div class="sidebar-header">
            <h4><i class="fas fa-chart-line"></i> <span>KESKA</span></h4>
            <small>Mali Takip Sistemi</small>
        </div>

        <div class="sidebar-user">
            <div class="user-name"><?= $auth->user()['full_name'] ?? 'Kullanıcı' ?></div>
            <div class="user-role"><?= $auth->user()['role'] ?? '' ?></div>
        </div>

        <div class="sidebar-menu">
            <a href="<?= BASE_URL ?>/dashboard" class="<?= ($currentPage ?? '') == 'dashboard' ? 'active' : '' ?>">
                <i class="fas fa-home"></i> <span>Ana Sayfa</span>
            </a>
            <a href="<?= BASE_URL ?>/suppliers" class="<?= ($currentPage ?? '') == 'suppliers' ? 'active' : '' ?>">
                <i class="fas fa-users"></i> <span>Tedarikçiler</span>
            </a>
            <a href="<?= BASE_URL ?>/checks" class="<?= ($currentPage ?? '') == 'checks' ? 'active' : '' ?>">
                <i class="fas fa-money-check-alt"></i> <span>Çek Takibi</span>
            </a>
            <a href="<?= BASE_URL ?>/banks" class="<?= ($currentPage ?? '') == 'banks' ? 'active' : '' ?>">
                <i class="fas fa-university"></i> <span>Bankalar</span>
            </a>
            <a href="<?= BASE_URL ?>/credit-cards"
                class="<?= ($currentPage ?? '') == 'credit-cards' ? 'active' : '' ?>">
                <i class="fas fa-credit-card"></i> <span>Kredi Kartları</span>
            </a>
            <a href="<?= BASE_URL ?>/monthly-payments"
                class="<?= ($currentPage ?? '') == 'monthly-payments' ? 'active' : '' ?>">
                <i class="fas fa-calendar-alt"></i> <span>Aylık Ödemeler</span>
            </a>
            <a href="<?= BASE_URL ?>/personnel-attendance"
                class="<?= ($currentPage ?? '') == 'personnel-attendance' ? 'active' : '' ?>">
                <i class="fas fa-clipboard-check"></i> <span>Personel Puantaj</span>
            </a>
            <?php if (($auth->user()['role'] ?? 'user') === 'admin'): ?>
            <a href="<?= BASE_URL ?>/personnel-salary"
                class="<?= ($currentPage ?? '') == 'personnel-salary' ? 'active' : '' ?>">
                <i class="fas fa-money-bill-wave"></i> <span>Personel Maaş</span>
            </a>
            <?php endif; ?>
            <a href="<?= BASE_URL ?>/calendar" class="<?= ($currentPage ?? '') == 'calendar' ? 'active' : '' ?>">
                <i class="fas fa-calendar"></i> <span>Takvim</span>
            </a>
            <a href="<?= BASE_URL ?>/all-payments"
                class="<?= ($currentPage ?? '') == 'all-payments' ? 'active' : '' ?>">
                <i class="fas fa-list"></i> <span>Tüm Ödemeler</span>
            </a>
            <a href="<?= BASE_URL ?>/import" class="<?= ($currentPage ?? '') == 'import' ? 'active' : '' ?>">
                <i class="fas fa-file-excel"></i> <span>Excel İçe Aktar</span>
            </a>
            <hr style="border-color: rgba(255,255,255,0.1); margin: 10px 0;">
            <a href="<?= BASE_URL ?>/logout">
                <i class="fas fa-sign-out-alt"></i> <span>Çıkış</span>
            </a>
        </div>
    </nav>

    <!-- Mobile Menu Button -->
    <button class="mobile-menu-btn" onclick="toggleMobileSidebar()">
        <i class="fas fa-bars"></i>
    </button>

    <!-- Main Content -->
    <div class="main-content" id="mainContent">
        <div class="top-navbar">
            <h5><?= $pageTitle ?? 'Dashboard' ?></h5>
            <div class="top-navbar-right">
                <i class="fas fa-calendar-day"></i>
                <?= date('d.m.Y') ?>
            </div>
        </div>

        <?php
        $flash = Helper::getFlash();
        if ($flash):
            ?>
            <div class="alert alert-<?= $flash['type'] ?> alert-dismissible fade show" role="alert">
                <?= Helper::escape($flash['message']) ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <script>
            function toggleSidebar() {
                const sidebar = document.getElementById('sidebar');
                const mainContent = document.getElementById('mainContent');
                sidebar.classList.toggle('collapsed');
                mainContent.classList.toggle('expanded');

                // Icon değiştir
                const icon = document.querySelector('.sidebar-toggle i');
                if (sidebar.classList.contains('collapsed')) {
                    icon.className = 'fas fa-chevron-right';
                } else {
                    icon.className = 'fas fa-chevron-left';
                }
            }

            function toggleMobileSidebar() {
                const sidebar = document.getElementById('sidebar');
                sidebar.classList.toggle('show');
            }

            // Close sidebar when clicking outside on mobile
            document.addEventListener('click', function (event) {
                if (window.innerWidth <= 768) {
                    const sidebar = document.getElementById('sidebar');
                    const mobileBtn = document.querySelector('.mobile-menu-btn');
                    if (!sidebar.contains(event.target) && !mobileBtn.contains(event.target)) {
                        sidebar.classList.remove('show');
                    }
                }
            });
        </script>