<?php
$pageTitle = 'Ana Sayfa';
$currentPage = 'dashboard';
include __DIR__ . '/../layout/header.php';
?>

<!-- Dashboard Stats Cards -->
<div class="row mb-4">
    <!-- Bugünkü Ödemeler -->
    <div class="col-md-3 mb-3">
        <div class="stat-card glass-card">
            <div class="stat-icon">
                <div class="icon-wrapper animated-gradient">
                    <i class="fas fa-calendar-day"></i>
                </div>
            </div>
            <div class="stat-content">
                <h6 class="stat-label"><i class="fas fa-circle" style="font-size: 6px; margin-right: 6px;"></i> Bugünkü
                    Ödemeler</h6>
                <h2 class="stat-value" data-count="<?= $summary['today_count'] ?? 0 ?>">0</h2>
                <div class="stat-detail">
                    <span class="amount"><?= Helper::formatMoney($summary['today_amount'] ?? 0) ?></span>
                </div>
            </div>
        </div>
    </div>

    <!-- Bu Haftaki Ödemeler -->
    <div class="col-md-3 mb-3">
        <div class="stat-card glass-card">
            <div class="stat-icon">
                <div class="icon-wrapper animated-gradient warning">
                    <i class="fas fa-calendar-week"></i>
                </div>
            </div>
            <div class="stat-content">
                <h6 class="stat-label"><i class="fas fa-circle" style="font-size: 6px; margin-right: 6px;"></i> Bu Hafta
                </h6>
                <h2 class="stat-value" data-count="<?= $summary['week_count'] ?? 0 ?>">0</h2>
                <div class="stat-detail">
                    <span class="amount"><?= Helper::formatMoney($summary['week_amount'] ?? 0) ?></span>
                    <?php if (isset($summary['week_trend'])): ?>
                        <span class="trend <?= $summary['week_trend'] > 0 ? 'positive' : 'negative' ?>">
                            <i class="fas fa-arrow-<?= $summary['week_trend'] > 0 ? 'up' : 'down' ?>"></i>
                            <?= abs($summary['week_trend']) ?>%
                        </span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Geciken Ödemeler -->
    <div class="col-md-3 mb-3">
        <div class="stat-card glass-card">
            <div class="stat-icon">
                <div class="icon-wrapper animated-gradient danger">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
            </div>
            <div class="stat-content">
                <h6 class="stat-label"><i class="fas fa-circle" style="font-size: 6px; margin-right: 6px;"></i> Gecikmiş
                </h6>
                <h2 class="stat-value" data-count="<?= $summary['overdue_count'] ?? 0 ?>">0</h2>
                <div class="stat-detail">
                    <span class="amount"><?= Helper::formatMoney($summary['overdue_amount'] ?? 0) ?></span>
                </div>
            </div>
        </div>
    </div>

    <!-- Müsait Limit -->
    <div class="col-md-3 mb-3">
        <div class="stat-card glass-card">
            <div class="stat-icon">
                <div class="icon-wrapper animated-gradient success">
                    <i class="fas fa-university"></i>
                </div>
            </div>
            <div class="stat-content">
                <h6 class="stat-label"><i class="fas fa-circle" style="font-size: 6px; margin-right: 6px;"></i> Müsait
                    Limit</h6>
                <h2 class="stat-value"><?= Helper::formatMoney($bankSummary['total_available'] ?? 0, false) ?></h2>
                <div class="stat-detail">
                    <span class="amount"><?= Helper::formatMoney($bankSummary['total_limit'] ?? 0) ?> toplam</span>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Tedarikçi ve Çek İstatistikleri -->
<div class="row mb-4">
    <!-- Tedarikçi Borç Toplamı -->
    <div class="col-md-3 mb-3">
        <div class="card bg-danger text-white">
            <div class="card-body">
                <h6 class="mb-2"><i class="fas fa-building"></i> Tedarikçi Borçları</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($supplierSummary['total_debt'] ?? 0, false) ?></h3>
                <small><?= intval($supplierSummary['total_suppliers'] ?? 0) ?> tedarikçi</small>
            </div>
        </div>
    </div>

    <!-- Bekleyen Alınan Çekler -->
    <div class="col-md-3 mb-3">
        <div class="card bg-success text-white">
            <div class="card-body">
                <h6 class="mb-2"><i class="fas fa-file-invoice-dollar"></i> Bekleyen Alınan Çekler</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($checkSummary['alinan_bekleyen_tutar'] ?? 0, false) ?></h3>
                <small><?= intval($checkSummary['alinan_bekleyen'] ?? 0) ?> adet</small>
            </div>
        </div>
    </div>

    <!-- Bekleyen Verilen Çekler -->
    <div class="col-md-3 mb-3">
        <div class="card bg-warning text-dark">
            <div class="card-body">
                <h6 class="mb-2"><i class="fas fa-money-check-alt"></i> Bekleyen Verilen Çekler</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($checkSummary['verilen_bekleyen_tutar'] ?? 0, false) ?></h3>
                <small><?= intval($checkSummary['verilen_bekleyen'] ?? 0) ?> adet</small>
            </div>
        </div>
    </div>

    <!-- Toplam Bakiye -->
    <div class="col-md-3 mb-3">
        <div class="card bg-info text-white">
            <div class="card-body">
                <h6 class="mb-2"><i class="fas fa-balance-scale"></i> Net Durum</h6>
                <?php
                $netBalance = ($checkSummary['alinan_bekleyen_tutar'] ?? 0) - ($checkSummary['verilen_bekleyen_tutar'] ?? 0) - ($supplierSummary['total_debt'] ?? 0);
                ?>
                <h3 class="mb-0"><?= Helper::formatMoney($netBalance, false) ?></h3>
                <small>alacak - borç</small>
            </div>
        </div>
    </div>
</div>

<!-- Yaklaşan Ödemeler -->
<div class="row">
    <div class="col-12">
        <div class="card glass-card">
            <div class="card-header bg-white">
                <h5 class="mb-0">
                    <i class="fas fa-clock text-primary"></i> Önümüzdeki 7 Gün
                </h5>
            </div>
            <div class="card-body">
                <?php if (empty($upcomingPayments)): ?>
                    <div class="alert alert-info" style="border-left: 4px solid #3B82F6;">
                        <i class="fas fa-info-circle"></i>
                        Önümüzdeki 7 gün içinde ödeme bulunmuyor.
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th><i class="fas fa-calendar"></i> Tarih</th>
                                    <th><i class="fas fa-file-invoice"></i> Ödeme Adı</th>
                                    <th><i class="fas fa-info-circle"></i> Detay</th>
                                    <th class="text-end"><i class="fas fa-lira-sign"></i> Tutar</th>
                                    <th><i class="fas fa-tag"></i> Kaynak</th>
                                    <th><i class="fas fa-check-circle"></i> Durum</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($upcomingPayments as $payment): ?>
                                    <tr>
                                        <td>
                                            <strong><?= Helper::formatDate($payment['payment_date']) ?></strong>
                                            <br>
                                            <small class="text-muted">
                                                <?php
                                                $days = Helper::daysDifference($payment['payment_date']);
                                                if ($days == 0)
                                                    echo '<span class="badge bg-danger">Bugün</span>';
                                                elseif ($days == 1)
                                                    echo '<span class="badge bg-warning">Yarın</span>';
                                                else
                                                    echo '<span class="badge bg-info">' . $days . ' gün sonra</span>';
                                                ?>
                                            </small>
                                        </td>
                                        <td>
                                            <strong><?= Helper::escape($payment['payment_name']) ?></strong>
                                        </td>
                                        <td><?= Helper::escape($payment['detail'] ?? '-') ?></td>
                                        <td class="text-end">
                                            <strong class="text-primary"><?= Helper::formatMoney($payment['amount']) ?></strong>
                                        </td>
                                        <td>
                                            <span class="badge bg-secondary">
                                                <?= Helper::escape($payment['category']) ?>
                                            </span>
                                        </td>
                                        <td>
                                            <span class="badge bg-<?= Helper::getStatusBadge($payment['status']) ?>">
                                                <?= Helper::translateStatus($payment['status']) ?>
                                            </span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- Charts Section -->
<div class="row mt-4">
    <div class="col-md-8">
        <div class="card glass-card">
            <div class="card-header bg-white">
                <h5 class="mb-0">
                    <i class="fas fa-chart-line text-primary"></i> Aylık Ödeme Trendi
                </h5>
            </div>
            <div class="card-body">
                <canvas id="monthlyTrendChart" height="80"></canvas>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card glass-card">
            <div class="card-header bg-white">
                <h5 class="mb-0">
                    <i class="fas fa-chart-pie text-primary"></i> Kategori Dağılımı
                </h5>
            </div>
            <div class="card-body">
                <canvas id="categoryChart"></canvas>
            </div>
        </div>
    </div>
</div>

<script>
    // Glassmorphic Chart Options
    const glassChartOptions = {
        responsive: true,
        maintainAspectRatio: true,
        plugins: {
            legend: {
                labels: {
                    font: {
                        family: 'Inter',
                        size: 12
                    },
                    padding: 15,
                    usePointStyle: true,
                    pointStyle: 'circle'
                }
            },
            tooltip: {
                backgroundColor: 'rgba(255, 255, 255, 0.95)',
                titleColor: '#1F2937',
                bodyColor: '#6B7280',
                borderColor: 'rgba(99, 102, 241, 0.2)',
                borderWidth: 1,
                padding: 12,
                cornerRadius: 12,
                displayColors: true,
                boxPadding: 6
            }
        },
        animation: {
            duration: 2000,
            easing: 'easeInOutQuart'
        }
    };

    // Monthly Trend Chart
    const ctx1 = document.getElementById('monthlyTrendChart');
    const gradient1 = ctx1.getContext('2d').createLinearGradient(0, 0, 0, 400);
    gradient1.addColorStop(0, 'rgba(99, 102, 241, 0.2)');
    gradient1.addColorStop(1, 'rgba(99, 102, 241, 0)');

    new Chart(ctx1, {
        type: 'line',
        data: {
            labels: ['Ocak', 'Şubat', 'Mart', 'Nisan', 'Mayıs', 'Haziran'],
            datasets: [{
                label: 'Ödemeler (₺)',
                data: [120000, 150000, 180000, 160000, 190000, 210000],
                borderColor: '#6366F1',
                backgroundColor: gradient1,
                fill: true,
                tension: 0.4,
                borderWidth: 3,
                pointRadius: 5,
                pointHoverRadius: 7,
                pointBackgroundColor: '#fff',
                pointBorderColor: '#6366F1',
                pointBorderWidth: 2
            }]
        },
        options: {
            ...glassChartOptions,
            scales: {
                y: {
                    beginAtZero: true,
                    grid: {
                        color: 'rgba(99, 102, 241, 0.1)',
                        drawBorder: false
                    },
                    ticks: {
                        callback: function (value) {
                            return value.toLocaleString('tr-TR') + ' ₺';
                        }
                    }
                },
                x: {
                    grid: {
                        display: false
                    }
                }
            }
        }
    });

    // Category Chart
    const ctx2 = document.getElementById('categoryChart');
    new Chart(ctx2, {
        type: 'doughnut',
        data: {
            labels: ['Tedarikçi', 'Kredi Kartı', 'KDV', 'SGK', 'Maaş'],
            datasets: [{
                data: [35, 25, 15, 15, 10],
                backgroundColor: [
                    '#6366F1',
                    '#8B5CF6',
                    '#F59E0B',
                    '#3B82F6',
                    '#10B981'
                ],
                borderWidth: 0,
                hoverOffset: 10
            }]
        },
        options: {
            ...glassChartOptions,
            cutout: '65%',
            plugins: {
                ...glassChartOptions.plugins,
                legend: {
                    position: 'bottom',
                    labels: {
                        font: {
                            family: 'Inter',
                            size: 11
                        },
                        padding: 12,
                        usePointStyle: true
                    }
                }
            }
        }
    });
</script>

<?php include __DIR__ . '/../layout/footer.php'; ?>