<?php include __DIR__ . '/../layout/header.php'; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-edit"></i> Kredi Kartı Düzenle</h2>
    <a href="<?= BASE_URL ?>/credit-cards" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Geri Dön
    </a>
</div>

<div class="card glass-card">
    <div class="card-body">
        <form action="<?= BASE_URL ?>/credit-cards/update/<?= $card['id'] ?>" method="POST">
            <div class="row g-3">
                <div class="col-md-6">
                    <label for="bank_name" class="form-label">Banka Adı</label>
                    <input type="text" class="form-control" id="bank_name" name="bank_name"
                        value="<?= Helper::escape($card['bank_name']) ?>" required>
                </div>
                <div class="col-md-6">
                    <label for="card_name" class="form-label">Kart Adı</label>
                    <input type="text" class="form-control" id="card_name" name="card_name"
                        value="<?= Helper::escape($card['card_name']) ?>" required>
                </div>
                <div class="col-md-4">
                    <label for="card_number_last4" class="form-label">Kart Son 4 Hane</label>
                    <input type="text" class="form-control" id="card_number_last4" name="card_number_last4"
                        value="<?= Helper::escape($card['card_number_last4']) ?>" maxlength="4" pattern="\d{4}">
                </div>
                <div class="col-md-4">
                    <label for="card_limit" class="form-label">Kart Limiti</label>
                    <input type="number" step="0.01" class="form-control" id="card_limit" name="card_limit"
                        value="<?= $card['card_limit'] ?>" required>
                </div>
                <div class="col-md-4">
                    <label for="current_debt" class="form-label">Mevcut Borç</label>
                    <input type="number" step="0.01" class="form-control" id="current_debt" name="current_debt"
                        value="<?= $card['current_debt'] ?>" min="0">
                </div>
                <div class="col-md-6">
                    <label for="statement_day" class="form-label">Hesap Kesim Günü (Sabit - Her Ay)</label>
                    <input type="number" class="form-control" id="statement_day" name="statement_day"
                        value="<?= $card['statement_day'] ?>" min="1" max="31" required>
                    <small class="text-muted">Örn: Her ayın 8. günü</small>
                </div>
                <div class="col-md-6">
                    <label for="payment_due_day" class="form-label">Son Ödeme Günü (Varsayılan - Her Ay)</label>
                    <input type="number" class="form-control" id="payment_due_day" name="payment_due_day"
                        value="<?= $card['payment_due_day'] ?>" min="1" max="31" required>
                    <small class="text-muted">Örn: Her ayın 18. günü</small>
                </div>
            </div>

            <hr class="my-4">
            <h5 class="mb-3"><i class="fas fa-calendar-check"></i> Güncel Dönem Bilgileri</h5>
            <p class="text-muted">Bu bilgiler her dönem güncellenir ve takvimde gösterilir</p>
            <div class="row g-3">
                <div class="col-md-6">
                    <label for="statement_amount" class="form-label">Dönem Sonu Borç</label>
                    <input type="number" step="0.01" class="form-control" id="statement_amount" name="statement_amount"
                        value="<?= $card['statement_amount'] ?? 0 ?>" min="0">
                </div>
                <div class="col-md-6">
                    <label for="minimum_payment" class="form-label">Asgari Ödeme</label>
                    <input type="number" step="0.01" class="form-control" id="minimum_payment" name="minimum_payment"
                        value="<?= $card['minimum_payment'] ?? 0 ?>" min="0">
                </div>
                <div class="col-md-6">
                    <label for="due_date" class="form-label">Bu Dönem Son Ödeme Tarihi</label>
                    <input type="date" class="form-control" id="due_date" name="due_date"
                        value="<?= $card['due_date'] ?? '' ?>">
                    <small class="text-muted">Farklı ise giriniz (Bayram, tatil vb.)</small>
                </div>
                <div class="col-12">
                    <div class="form-check form-switch">
                        <input class="form-check-input" type="checkbox" id="is_active" name="is_active"
                            <?= $card['is_active'] ? 'checked' : '' ?>>
                        <label class="form-check-label" for="is_active">Kart Aktif</label>
                    </div>
                </div>
                <div class="col-12 text-end">
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save"></i> Güncelle
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>