<?php include __DIR__ . '/../layout/header.php'; ?>

<!-- Page Header -->
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-university"></i> <?= Helper::escape($bank['bank_name']) ?></h2>
    <div class="btn-group">
        <a href="<?= BASE_URL ?>/banks" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Geri
        </a>
    </div>
</div>

<!-- Balance Summary Cards -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card glass-card bg-gradient-primary text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-wallet"></i> Limit</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($bank['limit_amount']) ?></h3>
                <small><?= translateAccountType($bank['account_type']) ?></small>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card glass-card bg-gradient-danger text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-arrow-up"></i> Toplam Borç</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($balance['total_borrows']) ?></h3>
                <small><?= $balance['transaction_count'] ?> işlem</small>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card glass-card bg-gradient-success text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-arrow-down"></i> Toplam Ödeme</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($balance['total_payments']) ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card glass-card bg-<?= $balance['balance'] > 0 ? 'warning' : 'secondary' ?> text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-balance-scale"></i> Kalan Bakiye</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($balance['balance']) ?></h3>
            </div>
        </div>
    </div>
</div>

<!-- Transaction List -->
<div class="card glass-card mb-4">
    <div class="card-header bg-white">
        <h5 class="mb-0"><i class="fas fa-list"></i> İşlem Geçmişi (<?= count($transactions) ?> kayıt)</h5>
    </div>
    <div class="card-body">
        <?php if (empty($transactions)): ?>
            <div class="alert alert-info" style="border-left: 4px solid #3B82F6;">
                <i class="fas fa-info-circle"></i> Henüz işlem kaydı yok. Aşağıdaki formu kullanarak yeni işlem ekleyebilirsiniz.
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th><i class="fas fa-calendar"></i> Tarih</th>
                            <th><i class="fas fa-tag"></i> Kategori</th>
                            <th><i class="fas fa-exchange-alt"></i> İşlem Tipi</th>
                            <th><i class="fas fa-file-alt"></i> Referans</th>
                            <th><i class="fas fa-info-circle"></i> Açıklama</th>
                            <th class="text-end"><i class="fas fa-lira-sign"></i> Tutar</th>
                            <th class="text-center"><i class="fas fa-cog"></i> İşlem</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($transactions as $trans): ?>
                            <tr>
                                <td>
                                    <i class="fas fa-calendar text-muted"></i>
                                    <?= Helper::formatDate($trans['transaction_date']) ?>
                                </td>
                                <td>
                                    <?php if ($trans['account_category']): ?>
                                        <span class="badge bg-<?= getCategoryBadge($trans['account_category']) ?>">
                                            <?= translateCategory($trans['account_category']) ?>
                                        </span>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <span class="badge bg-<?= getTransactionBadge($trans['transaction_type']) ?>">
                                        <?= translateTransactionType($trans['transaction_type']) ?>
                                    </span>
                                </td>
                                <td><?= Helper::escape($trans['reference_number'] ?? '-') ?></td>
                                <td><?= Helper::escape($trans['description'] ?? '-') ?></td>
                                <td class="text-end fw-bold <?= $trans['transaction_type'] === 'payment' ? 'text-success' : 'text-danger' ?>">
                                    <?= $trans['transaction_type'] === 'payment' ? '-' : '+' ?>
                                    <?= Helper::formatMoney($trans['amount']) ?>
                                </td>
                                <td class="text-center">
                                    <button type="button" class="btn btn-sm btn-danger"
                                            data-bs-toggle="modal"
                                            data-bs-target="#deleteTransModal<?= $trans['id'] ?>"
                                            title="İşlemi Sil">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>

                            <!-- Delete Modal for each transaction -->
                            <div class="modal fade" id="deleteTransModal<?= $trans['id'] ?>" tabindex="-1" aria-labelledby="deleteTransModalLabel<?= $trans['id'] ?>" aria-hidden="true">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="deleteTransModalLabel<?= $trans['id'] ?>">
                                                <i class="fas fa-exclamation-triangle text-warning"></i> İşlemi Sil
                                            </h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            <p>Bu işlemi silmek istediğinizden emin misiniz?</p>
                                            <div class="alert alert-warning mb-0">
                                                <small>
                                                    <strong>İşlem Detayı:</strong><br>
                                                    Tip: <?= translateTransactionType($trans['transaction_type']) ?><br>
                                                    Tutar: <?= Helper::formatMoney($trans['amount']) ?><br>
                                                    Tarih: <?= Helper::formatDate($trans['transaction_date']) ?>
                                                </small>
                                            </div>
                                            <p class="text-danger mt-2 mb-0"><small><i class="fas fa-info-circle"></i> Bu işlem geri alınamaz ve bakiye yeniden hesaplanacaktır!</small></p>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                                                <i class="fas fa-times"></i> İptal
                                            </button>
                                            <form method="POST" action="<?= BASE_URL ?>/banks/delete-transaction/<?= $bank['id'] ?>/<?= $trans['id'] ?>" class="d-inline">
                                                <button type="submit" class="btn btn-danger">
                                                    <i class="fas fa-trash"></i> Sil
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Add New Transaction Form -->
<div class="card glass-card">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0"><i class="fas fa-plus-circle"></i> Yeni İşlem Ekle</h5>
    </div>
    <div class="card-body">
        <form method="POST" action="<?= BASE_URL ?>/banks/save-transaction/<?= $bank['id'] ?>">
            <div class="row">
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="account_category" class="form-label">Hesap Kategorisi</label>
                        <select class="form-select" id="account_category" name="account_category">
                            <option value="">Genel</option>
                            <option value="bch">💳 BCH (Cari Hesap)</option>
                            <option value="kmh">🏦 KMH</option>
                            <option value="installment_loan">📅 Aylık Eş Taksitli Kredi</option>
                            <option value="credit_card">💳 Kredi Kartı</option>
                        </select>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="transaction_type" class="form-label">İşlem Tipi <span class="text-danger">*</span></label>
                        <select class="form-select" id="transaction_type" name="transaction_type" required>
                            <option value="">Seçiniz...</option>
                            <option value="borrow">⬆️ Borç Alındı</option>
                            <option value="payment">⬇️ Ödeme Yapıldı</option>
                            <option value="adjustment">⚙️ Düzeltme</option>
                        </select>
                    </div>
                </div>

                <div class="col-md-2">
                    <div class="mb-3">
                        <label for="amount" class="form-label">Tutar (₺) <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" class="form-control" id="amount"
                               name="amount" required min="0.01" placeholder="0.00">
                    </div>
                </div>

                <div class="col-md-2">
                    <div class="mb-3">
                        <label for="transaction_date" class="form-label">Tarih <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" id="transaction_date"
                               name="transaction_date" value="<?= date('Y-m-d') ?>" required>
                    </div>
                </div>

                <div class="col-md-2">
                    <div class="mb-3">
                        <label for="reference_number" class="form-label">Referans No</label>
                        <input type="text" class="form-control" id="reference_number"
                               name="reference_number" placeholder="Dekont No">
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <label for="description" class="form-label">Açıklama</label>
                <textarea class="form-control" id="description" name="description"
                          rows="2" placeholder="İşlem detayları (Opsiyonel)"></textarea>
            </div>

            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> İşlemi Kaydet
            </button>
        </form>
    </div>
</div>

<?php
/**
 * Helper functions for this view
 */
function getTransactionBadge($type) {
    switch ($type) {
        case 'borrow': return 'danger';
        case 'payment': return 'success';
        case 'adjustment': return 'secondary';
        default: return 'secondary';
    }
}

function translateTransactionType($type) {
    switch ($type) {
        case 'borrow': return 'Borç Alındı';
        case 'payment': return 'Ödeme';
        case 'adjustment': return 'Düzeltme';
        default: return $type;
    }
}

function getCategoryBadge($category) {
    switch ($category) {
        case 'bch': return 'primary';
        case 'kmh': return 'info';
        case 'installment_loan': return 'warning';
        case 'credit_card': return 'danger';
        default: return 'secondary';
    }
}

function translateCategory($category) {
    switch ($category) {
        case 'bch': return 'BCH';
        case 'kmh': return 'KMH';
        case 'installment_loan': return 'Taksitli Kredi';
        case 'credit_card': return 'Kredi Kartı';
        default: return $category;
    }
}

function translateAccountType($type) {
    switch ($type) {
        case 'kmh': return 'KMH';
        case 'current': return 'Cari Hesap';
        case 'deposit': return 'Mevduat';
        case 'bcl': return 'BCL';
        case 'installment': return 'Taksitli';
        default: return strtoupper($type);
    }
}
?>

<?php include __DIR__ . '/../layout/footer.php'; ?>
