<?php include __DIR__ . '/../../layout/header.php'; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-credit-card"></i> <?= Helper::escape($account['bank_name']) ?></h2>
    <a href="<?= BASE_URL ?>/banks/kmh" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Geri
    </a>
</div>

<?php
$flash = Helper::getFlash();
if ($flash):
?>
<div class="alert alert-<?= $flash['type'] ?> alert-dismissible fade show" role="alert">
    <?= Helper::escape($flash['message']) ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<!-- Bakiye Özet Kartları -->
<div class="row mb-4">
    <div class="col-md-3">
        <div class="card glass-card bg-gradient-primary text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-coins"></i> Limit</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($account['limit_amount']) ?></h3>
                <?php if ($account['account_subtype']): ?>
                    <small><?= Helper::escape($account['account_subtype']) ?></small>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card glass-card bg-gradient-danger text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-arrow-up"></i> Toplam Borç</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($balance['total_borrows']) ?></h3>
                <small><?= $balance['transaction_count'] ?> işlem</small>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card glass-card bg-gradient-success text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-arrow-down"></i> Toplam Ödeme</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($balance['total_payments']) ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card glass-card bg-<?= $account['used_amount'] > 0 ? 'warning' : 'secondary' ?> text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-wallet"></i> Müsait</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($account['available_amount']) ?></h3>
            </div>
        </div>
    </div>
</div>

<!-- İşlem Geçmişi -->
<div class="card glass-card mb-4">
    <div class="card-header bg-white">
        <h5 class="mb-0"><i class="fas fa-list"></i> İşlem Geçmişi (<?= count($transactions) ?> kayıt)</h5>
    </div>
    <div class="card-body">
        <?php if (empty($transactions)): ?>
            <div class="alert alert-info" style="border-left: 4px solid #3B82F6;">
                <i class="fas fa-info-circle"></i> Henüz işlem kaydı yok. Aşağıdaki formu kullanarak yeni işlem ekleyebilirsiniz.
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th><i class="fas fa-calendar"></i> Tarih</th>
                            <th><i class="fas fa-exchange-alt"></i> İşlem Tipi</th>
                            <th><i class="fas fa-file-alt"></i> Referans</th>
                            <th><i class="fas fa-info-circle"></i> Açıklama</th>
                            <th class="text-end"><i class="fas fa-lira-sign"></i> Tutar</th>
                            <th class="text-center"><i class="fas fa-cog"></i> İşlem</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($transactions as $trans): ?>
                            <tr>
                                <td>
                                    <i class="fas fa-calendar text-muted"></i>
                                    <?= Helper::formatDate($trans['transaction_date']) ?>
                                </td>
                                <td>
                                    <?php
                                    $badgeClass = $trans['transaction_type'] === 'borrow' ? 'danger' :
                                                 ($trans['transaction_type'] === 'payment' ? 'success' : 'secondary');
                                    $label = $trans['transaction_type'] === 'borrow' ? 'Borç Alındı' :
                                            ($trans['transaction_type'] === 'payment' ? 'Ödeme' : 'Düzeltme');
                                    ?>
                                    <span class="badge bg-<?= $badgeClass ?>"><?= $label ?></span>
                                </td>
                                <td><?= Helper::escape($trans['reference_number'] ?? '-') ?></td>
                                <td><?= Helper::escape($trans['description'] ?? '-') ?></td>
                                <td class="text-end fw-bold <?= $trans['transaction_type'] === 'payment' ? 'text-success' : 'text-danger' ?>">
                                    <?= $trans['transaction_type'] === 'payment' ? '-' : '+' ?>
                                    <?= Helper::formatMoney($trans['amount']) ?>
                                </td>
                                <td class="text-center">
                                    <button type="button" class="btn btn-sm btn-danger"
                                            data-bs-toggle="modal"
                                            data-bs-target="#deleteTransModal<?= $trans['id'] ?>"
                                            title="İşlemi Sil">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </td>
                            </tr>

                            <!-- Delete Transaction Modal -->
                            <div class="modal fade" id="deleteTransModal<?= $trans['id'] ?>" tabindex="-1">
                                <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">
                                                <i class="fas fa-exclamation-triangle text-warning"></i> İşlemi Sil
                                            </h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                        </div>
                                        <div class="modal-body">
                                            <p>Bu işlemi silmek istediğinizden emin misiniz?</p>
                                            <div class="alert alert-warning mb-0">
                                                <small>
                                                    <strong>Tip:</strong> <?= $label ?><br>
                                                    <strong>Tutar:</strong> <?= Helper::formatMoney($trans['amount']) ?><br>
                                                    <strong>Tarih:</strong> <?= Helper::formatDate($trans['transaction_date']) ?>
                                                </small>
                                            </div>
                                            <p class="text-danger mt-2 mb-0"><small><i class="fas fa-info-circle"></i> Bu işlem geri alınamaz ve bakiye yeniden hesaplanacaktır!</small></p>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                                            <form method="POST" action="<?= BASE_URL ?>/banks/kmh/delete-transaction/<?= $account['id'] ?>/<?= $trans['id'] ?>" class="d-inline">
                                                <button type="submit" class="btn btn-danger">
                                                    <i class="fas fa-trash"></i> Sil
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Yeni İşlem Ekleme Formu -->
<div class="card glass-card">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0"><i class="fas fa-plus-circle"></i> Yeni İşlem Ekle</h5>
    </div>
    <div class="card-body">
        <form method="POST" action="<?= BASE_URL ?>/banks/kmh/save-transaction/<?= $account['id'] ?>">
            <div class="row">
                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="transaction_type" class="form-label">İşlem Tipi <span class="text-danger">*</span></label>
                        <select class="form-select" id="transaction_type" name="transaction_type" required>
                            <option value="">Seçiniz...</option>
                            <option value="borrow">⬆️ Borç Alındı</option>
                            <option value="payment">⬇️ Ödeme Yapıldı</option>
                            <option value="adjustment">⚙️ Düzeltme</option>
                        </select>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="amount" class="form-label">Tutar (₺) <span class="text-danger">*</span></label>
                        <input type="number" step="0.01" class="form-control" id="amount"
                               name="amount" required min="0.01" placeholder="0.00">
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="transaction_date" class="form-label">Tarih <span class="text-danger">*</span></label>
                        <input type="date" class="form-control" id="transaction_date"
                               name="transaction_date" value="<?= date('Y-m-d') ?>" required>
                    </div>
                </div>

                <div class="col-md-3">
                    <div class="mb-3">
                        <label for="reference_number" class="form-label">Referans No</label>
                        <input type="text" class="form-control" id="reference_number"
                               name="reference_number" placeholder="Dekont No">
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <label for="description" class="form-label">Açıklama</label>
                <textarea class="form-control" id="description" name="description"
                          rows="2" placeholder="İşlem detayları (Opsiyonel)"></textarea>
            </div>

            <button type="submit" class="btn btn-primary">
                <i class="fas fa-save"></i> İşlemi Kaydet
            </button>
        </form>
    </div>
</div>

<?php include __DIR__ . '/../../layout/footer.php'; ?>
