<?php include __DIR__ . '/../../layout/header.php'; ?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-credit-card"></i> KMH (Kredili Mevduat Hesabı) Takibi</h2>
    <div class="btn-group">
        <a href="<?= BASE_URL ?>/banks/kmh/create" class="btn btn-primary">
            <i class="fas fa-plus"></i> Yeni KMH Ekle
        </a>
        <a href="<?= BASE_URL ?>/banks" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Geri
        </a>
    </div>
</div>

<?php
$flash = Helper::getFlash();
if ($flash):
?>
<div class="alert alert-<?= $flash['type'] ?> alert-dismissible fade show" role="alert">
    <?= Helper::escape($flash['message']) ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<!-- Özet Kartlar -->
<div class="row mb-3">
    <div class="col-md-3">
        <div class="card glass-card bg-gradient-primary text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-coins"></i> Toplam Limit</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($summary['total_limit'] ?? 0) ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card glass-card bg-gradient-danger text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-arrow-up"></i> Kullanılan</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($summary['total_used'] ?? 0) ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card glass-card bg-gradient-success text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-check-circle"></i> Müsait</h6>
                <h3 class="mb-0"><?= Helper::formatMoney($summary['total_available'] ?? 0) ?></h3>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card glass-card bg-gradient-info text-white">
            <div class="card-body">
                <h6 class="card-subtitle mb-2"><i class="fas fa-list"></i> Hesap Sayısı</h6>
                <h3 class="mb-0"><?= $summary['account_count'] ?? 0 ?></h3>
            </div>
        </div>
    </div>
</div>

<!-- KMH Listesi -->
<div class="card glass-card">
    <div class="card-body">
        <?php if (empty($kmhAccounts)): ?>
            <div class="alert alert-info">
                <i class="fas fa-info-circle"></i>
                Henüz KMH hesabı bulunmuyor. <a href="<?= BASE_URL ?>/banks/kmh/create">Yeni KMH ekleyin</a>.
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th><i class="fas fa-university"></i> Banka</th>
                            <th>Alt Tip</th>
                            <th class="text-end"><i class="fas fa-coins"></i> Limit</th>
                            <th class="text-end"><i class="fas fa-chart-line"></i> Kullanılan</th>
                            <th class="text-end"><i class="fas fa-wallet"></i> Müsait</th>
                            <th class="text-center"><i class="fas fa-list"></i> İşlem</th>
                            <th class="text-center"><i class="fas fa-cog"></i> İşlemler</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($kmhAccounts as $account): ?>
                        <tr>
                            <td>
                                <strong><?= Helper::escape($account['bank_name']) ?></strong>
                            </td>
                            <td>
                                <?php if ($account['account_subtype']): ?>
                                    <span class="badge bg-secondary">
                                        <?= Helper::escape($account['account_subtype']) ?>
                                    </span>
                                <?php else: ?>
                                    <span class="text-muted">-</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-end">
                                <?= Helper::formatMoney($account['limit_amount']) ?>
                            </td>
                            <td class="text-end">
                                <strong class="text-danger">
                                    <?= Helper::formatMoney($account['used_amount']) ?>
                                </strong>
                            </td>
                            <td class="text-end">
                                <strong class="text-success">
                                    <?= Helper::formatMoney($account['available_amount']) ?>
                                </strong>
                            </td>
                            <td class="text-center">
                                <span class="badge bg-info">
                                    <?= $account['transaction_count'] ?> işlem
                                </span>
                            </td>
                            <td class="text-center">
                                <div class="btn-group btn-group-sm">
                                    <a href="<?= BASE_URL ?>/banks/kmh/view/<?= $account['id'] ?>" class="btn btn-info" title="Detay & İşlemler">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?= BASE_URL ?>/banks/kmh/edit/<?= $account['id'] ?>" class="btn btn-warning" title="Düzenle">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    <button type="button" class="btn btn-danger"
                                            data-bs-toggle="modal"
                                            data-bs-target="#deleteModal<?= $account['id'] ?>"
                                            title="Sil">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </div>
                            </td>
                        </tr>

                        <!-- Delete Modal -->
                        <div class="modal fade" id="deleteModal<?= $account['id'] ?>" tabindex="-1">
                            <div class="modal-dialog">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h5 class="modal-title">
                                            <i class="fas fa-exclamation-triangle text-warning"></i> KMH Hesabı Sil
                                        </h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                    </div>
                                    <div class="modal-body">
                                        <p>Bu KMH hesabını silmek istediğinizden emin misiniz?</p>
                                        <div class="alert alert-warning">
                                            <strong>Banka:</strong> <?= Helper::escape($account['bank_name']) ?><br>
                                            <strong>Limit:</strong> <?= Helper::formatMoney($account['limit_amount']) ?><br>
                                            <strong>Kullanılan:</strong> <?= Helper::formatMoney($account['used_amount']) ?>
                                        </div>
                                        <p class="text-danger mb-0"><small><i class="fas fa-info-circle"></i> Bu işlem tüm işlem geçmişini de silecektir!</small></p>
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">İptal</button>
                                        <form method="POST" action="<?= BASE_URL ?>/banks/kmh/delete/<?= $account['id'] ?>" class="d-inline">
                                            <button type="submit" class="btn btn-danger">
                                                <i class="fas fa-trash"></i> Sil
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include __DIR__ . '/../../layout/footer.php'; ?>
