<?php
include __DIR__ . '/../layout/header.php';
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-university"></i> Banka Borç Takibi</h2>
</div>

<?php
$flash = Helper::getFlash();
if ($flash):
?>
<div class="alert alert-<?= $flash['type'] ?> alert-dismissible fade show" role="alert">
    <?= Helper::escape($flash['message']) ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
</div>
<?php endif; ?>

<!-- 3 Kart: BCH, KMH, Taksitli Krediler -->
<div class="row g-4">
    <!-- BCH Kartı -->
    <div class="col-md-4">
        <div class="card glass-card h-100">
            <div class="card-body text-center">
                <div class="mb-3">
                    <div class="icon-wrapper animated-gradient mx-auto" style="width: 80px; height: 80px; border-radius: 50%; display: flex; align-items: center; justify-content: center;">
                        <i class="fas fa-file-invoice-dollar fa-2x text-white"></i>
                    </div>
                </div>
                <h5 class="card-title">BCH Takibi</h5>
                <p class="text-muted">Banka Cari Hesabı</p>
                <div class="mb-3">
                    <h3 class="text-primary" data-count="<?= $bchSummary['pending_total'] ?? 0 ?>">
                        <?= Helper::formatMoney($bchSummary['pending_total'] ?? 0) ?>
                    </h3>
                    <small class="text-muted"><?= $bchSummary['pending_count'] ?? 0 ?> bekleyen ödeme</small>
                </div>
                <a href="<?= BASE_URL ?>/banks/bch" class="btn btn-primary w-100">
                    <i class="fas fa-arrow-right"></i> Detay
                </a>
            </div>
        </div>
    </div>

    <!-- KMH Kartı -->
    <div class="col-md-4">
        <div class="card glass-card h-100">
            <div class="card-body text-center">
                <div class="mb-3">
                    <div class="icon-wrapper animated-gradient mx-auto" style="width: 80px; height: 80px; border-radius: 50%; display: flex; align-items: center; justify-content: center; background: linear-gradient(135deg, #48c6ef 0%, #6f86d6 100%);">
                        <i class="fas fa-credit-card fa-2x text-white"></i>
                    </div>
                </div>
                <h5 class="card-title">KMH Takibi</h5>
                <p class="text-muted">Kredili Mevduat Hesabı</p>
                <div class="mb-3">
                    <h3 class="text-info" data-count="<?= $kmhSummary['used_total'] ?? 0 ?>">
                        <?= Helper::formatMoney($kmhSummary['used_total'] ?? 0) ?>
                    </h3>
                    <small class="text-muted"><?= $kmhSummary['account_count'] ?? 0 ?> hesap | Limit: <?= Helper::formatMoney($kmhSummary['limit_total'] ?? 0) ?></small>
                </div>
                <a href="<?= BASE_URL ?>/banks/kmh" class="btn btn-info w-100">
                    <i class="fas fa-arrow-right"></i> Detay
                </a>
            </div>
        </div>
    </div>

    <!-- Taksitli Krediler Kartı -->
    <div class="col-md-4">
        <div class="card glass-card h-100">
            <div class="card-body text-center">
                <div class="mb-3">
                    <div class="icon-wrapper animated-gradient mx-auto" style="width: 80px; height: 80px; border-radius: 50%; display: flex; align-items: center; justify-content: center; background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                        <i class="fas fa-calendar-check fa-2x text-white"></i>
                    </div>
                </div>
                <h5 class="card-title">Taksitli Krediler</h5>
                <p class="text-muted">Aylık Eş Taksitli</p>
                <div class="mb-3">
                    <h3 class="text-warning" data-count="<?= $installmentSummary['monthly_total'] ?? 0 ?>">
                        <?= Helper::formatMoney($installmentSummary['monthly_total'] ?? 0) ?>
                    </h3>
                    <small class="text-muted"><?= $installmentSummary['loan_count'] ?? 0 ?> kredi | Aylık ödeme</small>
                </div>
                <a href="<?= BASE_URL ?>/banks/installment-loans" class="btn btn-warning w-100">
                    <i class="fas fa-arrow-right"></i> Detay
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Genel Bilgi -->
<div class="row mt-4">
    <div class="col-12">
        <div class="card glass-card">
            <div class="card-body">
                <h5 class="card-title"><i class="fas fa-info-circle"></i> Banka Borç Tipleri</h5>
                <div class="row">
                    <div class="col-md-4">
                        <h6><i class="fas fa-file-invoice-dollar text-primary"></i> BCH (Banka Cari Hesabı)</h6>
                        <p class="text-muted small">Tek seferlik sabit ödemeler. Her BCH bir vade tarihi ile birlikte gelir ve o tarihte ödenmesi beklenir.</p>
                    </div>
                    <div class="col-md-4">
                        <h6><i class="fas fa-credit-card text-info"></i> KMH (Kredili Mevduat Hesabı)</h6>
                        <p class="text-muted small">Değişken bakiyeli kredi limitleri. Limit dahilinde borç alınıp ödenebilir. Her işlem kaydedilir.</p>
                    </div>
                    <div class="col-md-4">
                        <h6><i class="fas fa-calendar-check text-warning"></i> Taksitli Krediler</h6>
                        <p class="text-muted small">Sabit aylık taksitli krediler. Her ay belirli bir tutar ödenir ve kalan taksit sayısı takip edilir.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include __DIR__ . '/../layout/footer.php'; ?>
