-- Tedarikçi İşlem Takibi Tablosu
-- Her tedarikçi için alım, ödeme, iade ve düzeltme işlemlerini takip eder

CREATE TABLE IF NOT EXISTS supplier_transactions (
    id INT PRIMARY KEY AUTO_INCREMENT,
    supplier_id INT NOT NULL,
    transaction_type ENUM('purchase', 'payment', 'refund', 'adjustment') NOT NULL,
    amount DECIMAL(15,2) NOT NULL,
    transaction_date DATE NOT NULL,
    reference_number VARCHAR(100),
    description TEXT,
    created_by INT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,

    FOREIGN KEY (supplier_id) REFERENCES suppliers(id) ON DELETE CASCADE,
    FOREIGN KEY (created_by) REFERENCES users(id) ON DELETE SET NULL,
    INDEX idx_supplier_trans (supplier_id, transaction_date),
    INDEX idx_trans_type (transaction_type),
    INDEX idx_trans_date (transaction_date)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_turkish_ci;
