-- ============================================================================
-- Banka Borclari - Guncel Durum Yukleme
-- Tarih: 2026-02-10
-- Kaynak: Paylasilan borc gorseli (BCH / KMH / Aylik Es Taksitli Krediler)
-- ============================================================================
-- NOT:
-- 1) Bu script ilgili tablolardaki mevcut banka borcu kayitlarini temizleyip
--    gorseldeki rakamlarla yeniden olusturur.
-- 2) Calistirmadan once yedek almaniz onerilir.
-- ============================================================================

START TRANSACTION;

-- --------------------------------------------------------------------------
-- 1) BCH (tek seferlik ve sabit vade)
-- --------------------------------------------------------------------------
DELETE FROM bank_bch;

INSERT INTO bank_bch (bank_name, amount, due_date, status, payment_date, description)
VALUES
('ZIRAAT BANK-BCH', 0.00, '2026-02-01', 'ÖDEME', '2026-02-01', '300 bin odendi; KMH ile kapatildi'),
('AKBANK-BCH', 350000.00, '2026-02-18', 'BEKLEMEDE', NULL, NULL),
('ZIRAAT BANK-BCH', 200000.00, '2026-04-17', 'BEKLEMEDE', NULL, NULL),
('HALK BANK-BCH', 300000.00, '2026-05-07', 'BEKLEMEDE', NULL, NULL),
('HALK BANK-BCH', 500000.00, '2026-05-26', 'BEKLEMEDE', NULL, NULL),
('ZIRAAT BANK-BCH', 100000.00, '2026-05-26', 'BEKLEMEDE', NULL, NULL),
('HALK BANK-BCH', 575000.00, '2026-06-05', 'BEKLEMEDE', NULL, NULL),
('ZIRAAT BANK-BCH', 100000.00, '2026-06-12', 'BEKLEMEDE', NULL, NULL),
('AKBANK-BCH', 350000.00, '2026-06-13', 'BEKLEMEDE', NULL, NULL);

-- --------------------------------------------------------------------------
-- 2) KMH (degisken borc / limit)
-- --------------------------------------------------------------------------
DELETE bt
FROM bank_transactions bt
INNER JOIN banks b ON b.id = bt.bank_id
WHERE b.account_type = 'kmh';
DELETE FROM banks WHERE account_type = 'kmh';

INSERT INTO banks (bank_name, limit_amount, used_amount, account_type, last_update_date, notes)
VALUES
('HALK BANK-BIREYSEL', 350000.00, 271000.00, 'kmh', '2026-02-10', 'Guncel KMH borcu'),
('HALK BANK-TICARI', 100000.00, 92000.00, 'kmh', '2026-02-10', 'Guncel KMH borcu'),
('GARANTI BANK', 150000.00, 98000.00, 'kmh', '2026-02-10', 'Guncel KMH borcu'),
('AKBANK', 50000.00, 0.00, 'kmh', '2026-02-10', 'Odendi'),
('IS BANK', 250000.00, 53500.00, 'kmh', '2026-02-10', 'Guncel KMH borcu'),
('ZIRAAT BANK', 30000.00, 0.00, 'kmh', '2026-02-10', 'Odendi'),
('YAPI KREDI', 100000.00, 90000.00, 'kmh', '2026-02-10', 'Guncel KMH borcu');

-- --------------------------------------------------------------------------
-- 3) Aylik Es Taksitli Krediler (sabit aylik odeme)
-- --------------------------------------------------------------------------
DELETE FROM bank_installment_payments;
DELETE FROM bank_installment_loans;

INSERT INTO bank_installment_loans (
    bank_name,
    loan_amount,
    monthly_payment,
    total_installments,
    remaining_installments,
    start_date,
    next_payment_date,
    status,
    description
)
VALUES
('GARANTI BANK', 500000.00, 35427.77, 1, 1, '2026-01-01', '2026-03-01', 'DEVAM EDİYOR', 'Odeme gunu: 1'),
('IS BANKASI', 600000.00, 63251.77, 1, 1, '2026-01-01', '2026-03-17', 'DEVAM EDİYOR', 'Odeme gunu: 17'),
('ZIRAAT BANK', 500000.00, 59106.73, 1, 1, '2026-01-01', '2026-03-20', 'DEVAM EDİYOR', 'Odeme gunu: 20'),
('HALK BANKASI', 850000.00, 56896.20, 1, 1, '2026-01-01', '2026-03-05', 'DEVAM EDİYOR', 'Odeme gunu: 5'),
('YAPI KREDI', 500000.00, 31398.79, 1, 1, '2026-01-01', '2026-03-19', 'DEVAM EDİYOR', 'Odeme gunu: 19'),
('ZIRAAT BANK', 500000.00, 57783.21, 1, 1, '2026-01-01', '2026-03-10', 'DEVAM EDİYOR', 'Odeme gunu: 10');

INSERT INTO bank_installment_payments (loan_id, payment_number, payment_date, amount, status)
SELECT id, 1, next_payment_date, monthly_payment, 'BEKLEMEDE'
FROM bank_installment_loans;

COMMIT;

-- Kontrol toplamlari:
-- BCH (beklemede): 2,475,000.00
-- KMH limit: 1,030,000.00
-- KMH kullanilan: 604,500.00
-- Taksitli kredi toplam kredi: 3,450,000.00
-- Taksitli kredi aylik toplam: 303,864.47
