<?php
/**
 * Excel Verilerini Veritabanına Aktarma - V2 (Düzeltilmiş)
 */

require_once __DIR__ . '/../includes/autoload.php';

echo "<h1>Veri İçe Aktarma (Düzeltilmiş)</h1>";

$db = Database::getInstance();

// 1. TEDARİKÇİ BORÇLARI
echo "<h2>1. Tedarikçi Borçları</h2>";

$suppliers = [
    ['AT1 GEOTEKNİK', null, 65000.00, null, 'ödeme talep etti', 'pending'],
    ['BTM Makina - Muhammet AÇIKGÖZ', null, 100000.00, null, 'ÖDEME TALEP ETTİ', 'pending'],
    ['Ceri Makina - Fikret Öztürk', null, 93000.00, null, 'ödeme talep etti', 'pending'],
    ['Ceri Teknik Makina', null, 93000.00, null, null, 'pending'],
    ['Çetin DÜZ - Bestchem', null, 2448.00, null, null, 'pending'],
    ['Çözüm Laboratuvar', null, 802083.72, null, 'son gelen ekstre', 'pending'],
    ['ÇTM Derece Sağlık', null, 14575.00, null, null, 'pending'],
    ['Derece OSGB', null, 7296.00, null, null, 'pending'],
    ['EROL KAYA - Mali Müşavir', null, 2490.71, null, null, 'pending'],
    ['FURKAN SONDAJ', null, 663456.80, null, null, 'pending'],
    ['Hasan Usta (ASLAN)', null, 45000.00, null, null, 'pending'],
    ['Hüseyin DANAĞI', null, 25000.00, null, null, 'pending'],
    ['İskender Sevencan Sondaj', null, 50000.00, null, null, 'pending'],
    ['KAV Oto Hidrolik yaş', null, 53634.00, null, null, 'pending'],
    ['Okan UÇÖZ', null, 20000.00, null, 'eski borç,ödenmesi gerekiyor', 'pending'],
    ['ÖNCÜ OTOMASYON', null, 47806.80, null, null, 'pending'],
    ['YER TEKNİK ORKUN', null, 137166.00, null, null, 'pending'],
    ['YEŞİLLER TEKNİK', null, 95527.31, null, 'ödeme talep ediyor', 'pending'],
];

foreach ($suppliers as $s) {
    $db->insert('suppliers', [
        'supplier_name' => $s[0],
        'invoice_number' => $s[1],
        'amount' => $s[2],
        'due_date' => $s[3],
        'description' => $s[4],
        'status' => $s[5],
        'created_by' => 1
    ]);
}
echo "<p class='text-success'>✓ " . count($suppliers) . " tedarikçi borcu eklendi</p>";

// 2. VERİLEN ÇEKLER
echo "<h2>2. Verilen Çekler</h2>";

$checks = [
    ['CENSAN SONDAJ', 'AKBANK', 19500.00, '2026-02-27'],
    ['YEŞİLLER PNÖMATİK', 'HALK B', 190000.00, '2026-03-06'],
    ['KAV OTO Hidrolik Yaş', 'ZİRAAT B', 45000.00, '2026-03-20'],
    ['KAV OTO Hidrolik Yaş', 'ZİRAAT B', 45000.00, '2026-04-24'],
    ['Furkan Sondaj Ekipmanları', 'İŞ BANK', 75000.00, '2026-04-24'],
    ['Furkan Sondaj Ekipmanları', 'İŞ BANK', 100000.00, '2026-05-29'],
    ['Furkan Sondaj Ekipmanları', 'İŞ BANK', 150000.00, '2026-06-25'],
];

foreach ($checks as $c) {
    $db->insert('suppliers', [
        'supplier_name' => $c[0],
        'invoice_number' => $c[1],
        'amount' => $c[2],
        'due_date' => $c[3],
        'status' => 'pending',
        'created_by' => 1
    ]);
}
echo "<p class='text-success'>✓ " . count($checks) . " verilen çek eklendi</p>";

// 3. ALINAN ÇEKLER
echo "<h2>3. Alınan Çekler</h2>";

$receivedChecks = [
    ['MUHAMMET BAHÇE', 'ZİRAAT B', 100000.00, '2026-02-16'],
    ['ALİ MİMARLIK MEHMET MERİÇ', 'DENİZBANK', 200000.00, '2026-03-13'],
    ['MURAT YILDIZ', 'QNB', 280000.00, '2026-05-22'],
    ['MURAT YILDIZ', 'QNB', 280000.00, '2026-06-19'],
    ['MURAT YILDIZ', 'QNB', 290000.00, '2026-07-24'],
];

foreach ($receivedChecks as $rc) {
    $db->insert('suppliers', [
        'supplier_name' => $rc[0] . ' (Alınan Çek)',
        'invoice_number' => $rc[1],
        'amount' => -$rc[2], // Negatif çünkü alacak
        'due_date' => $rc[3],
        'status' => 'pending',
        'created_by' => 1
    ]);
}
echo "<p class='text-success'>✓ " . count($receivedChecks) . " alınan çek eklendi</p>";

// 4. BANKALAR
echo "<h2>4. Bankalar</h2>";

$banks = [
    ['HALK BANK-BİREYSEL', 350000.00, 271000.00, 'kmh'],
    ['HALK BANK-TİCARİ', 100000.00, 92000.00, 'kmh'],
    ['GARANTİ BANK', 150000.00, 98000.00, 'kmh'],
    ['AKBANK', 50000.00, 0.00, 'kmh'],
    ['İŞ BANK', 250000.00, 53500.00, 'kmh'],
    ['ZİRAAT BANK', 30000.00, 0.00, 'kmh'],
    ['YAPI KREDİ', 100000.00, 90000.00, 'kmh'],
];

foreach ($banks as $b) {
    $db->insert('banks', [
        'bank_name' => $b[0],
        'limit_amount' => $b[1],
        'used_amount' => $b[2],
        'account_type' => $b[3]
    ]);
}
echo "<p class='text-success'>✓ " . count($banks) . " banka eklendi</p>";

// 5. AYLIK ÖDEMELER
echo "<h2>5. Aylık Ödemeler</h2>";

$monthlyPayments = [
    ['KDV', 25, 'kdv'],
    ['SGK', 30, 'sgk'],
    ['Vergi', 25, 'other'],
    ['Kira', 1, 'rent'],
    ['Elektrik', 5, 'electricity'],
    ['Su', 10, 'water'],
    ['Doğalgaz', 5, 'gas'],
    ['Telefon', 5, 'phone'],
    ['İnternet', 5, 'internet'],
    ['Maaşlar', 1, 'salary'],
];

foreach ($monthlyPayments as $mp) {
    $db->insert('monthly_payments', [
        'payment_name' => $mp[0],
        'payment_day' => $mp[1],
        'category' => $mp[2],
        'is_recurring' => 1
    ]);
}
echo "<p class='text-success'>✓ " . count($monthlyPayments) . " aylık ödeme eklendi</p>";

echo "<hr>";
echo "<h2 class='text-success'>✓ Tüm Veriler Başarıyla Aktarıldı!</h2>";
echo "<p><strong>Toplam:</strong></p>";
echo "<ul>";
echo "<li>" . count($suppliers) . " Tedarikçi Borcu</li>";
echo "<li>" . count($checks) . " Verilen Çek</li>";
echo "<li>" . count($receivedChecks) . " Alınan Çek</li>";
echo "<li>" . count($banks) . " Banka</li>";
echo "<li>" . count($monthlyPayments) . " Aylık Ödeme</li>";
echo "</ul>";
echo "<p><a href='" . BASE_URL . "/dashboard' class='btn btn-primary btn-lg'>Dashboard'a Git</a></p>";
