<?php
/**
 * Debug - Redirect loop tespiti
 */

echo "<h1>Debug Info</h1>";

echo "<h2>1. Config Test</h2>";
require_once __DIR__ . '/../includes/autoload.php';
echo "✓ Autoload başarılı<br>";
echo "BASE_URL: " . BASE_URL . "<br>";
echo "APP_DEBUG: " . (APP_DEBUG ? 'true' : 'false') . "<br>";

echo "<h2>2. Database Test</h2>";
try {
    $db = Database::getInstance();
    echo "✓ Database bağlantısı başarılı<br>";
} catch (Exception $e) {
    echo "✗ Database hatası: " . $e->getMessage() . "<br>";
}

echo "<h2>3. Session Test</h2>";
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
echo "✓ Session başlatıldı<br>";
echo "Session ID: " . session_id() . "<br>";
echo "Session data: ";
print_r($_SESSION);
echo "<br>";

echo "<h2>4. Auth Test</h2>";
try {
    $auth = new Auth();
    echo "✓ Auth instance oluşturuldu<br>";
    echo "isLoggedIn: " . ($auth->isLoggedIn() ? 'true' : 'false') . "<br>";
} catch (Exception $e) {
    echo "✗ Auth hatası: " . $e->getMessage() . "<br>";
}

echo "<h2>5. URL Parsing Test</h2>";
$requestUri = $_SERVER['REQUEST_URI'];
$scriptName = dirname($_SERVER['SCRIPT_NAME']);
$uri = str_replace($scriptName, '', $requestUri);
$uri = trim($uri, '/');
$uri = explode('?', $uri)[0];
$segments = explode('/', $uri);
$controller = $segments[0] ?: 'dashboard';

echo "REQUEST_URI: $requestUri<br>";
echo "SCRIPT_NAME: " . $_SERVER['SCRIPT_NAME'] . "<br>";
echo "Parsed URI: $uri<br>";
echo "Controller: $controller<br>";

echo "<h2>6. Redirect Test</h2>";
echo "Redirect to /login would go to: " . BASE_URL . "/login<br>";
echo "Redirect to /dashboard would go to: " . BASE_URL . "/dashboard<br>";

echo "<hr>";
echo "<a href='/KRMuhasebe/login'>Test: Go to Login</a><br>";
echo "<a href='/KRMuhasebe/dashboard'>Test: Go to Dashboard</a><br>";
