<?php
require_once __DIR__ . '/../includes/autoload.php';
$db = Database::getInstance();

// Personel listesi
$personnelList = [
    ['Tamer ONAT', 27.0],
    ['Ebru Ekşi ONAT', 21.0],
    ['Ali Özenç ŞAHİN', 27.0],
    ['Hakan DANACI', 26.0],
    ['Ömer KIYAĞAN', 24.0],
    ['Emrah MURAT', 24.0],
    ['Metin AYYILDIZ', 21.0],
    ['Ergün MÜLAYİM', 27.0],
    ['Erkan ÖZGÜR', 24.0],
    ['Yılmaz ÇETİN', 22.0],
    ['Muharrem TORAMAN', 27.0],
    ['Veli UÇMAN', 27.0],
    ['Önder ATASOY', 19.0],
    ['Arda İŞCAN', 26.0],
    ['Melih TAŞDEMİR', 18.0],
    ['Gökhan TORAMAN', 26.0],
    ['Demirkan Fırat DEMİRKAYA', 26.0],
    ['Elif MUT', 15.0],
    ['Mehmet DEMİRTAŞ', 27.0],
    ['Mehmet SEZER', 24.0],
    ['Sedat ONAY', 22.0],
    ['Tuğberk DOĞANÇAY', 19.0],
    ['Hüseyin BAYRAM', 27.0],
    ['Necdet ÇİFTÇİ', 24.0],
    ['Sezgin FERMAN', 26.0],
    ['Serdarhan KANPARA', 27.0],
    ['İbrahim ŞAHİN', 22.0],
    ['Fahrettin BELCİ', 27.0],
    ['Mustafa ÖZCAN', 15.0],
    ['Suat ARMER', 12.0],
    ['Ahmet Kerem AYDIN', 0],
    ['Kanan YILDIZ', 0],
    ['Sezgin FERMAN', 0],
    ['Ergun MÜLAYİM', 0],
    ['Necmettin ÖNER', 0],
    ['Yılmaz ÇETİN', 0],
    ['Ahmet DENİZ', 0],
    ['Necati YALIN', 0],
    ['Vedat KADAK', 0],
    ['Botir MAKHMANAZAROV', 0]
];

try {
    $count = 0;
    foreach ($personnelList as $person) {
        // Kontrol: Zaten var mı?
        $existing = $db->selectOne("SELECT id FROM personnel WHERE full_name = ?", [$person[0]]);

        if (!$existing) {
            $db->insert('personnel', [
                'full_name' => $person[0],
                'daily_wage' => $person[1],
                'is_active' => 1
            ]);
            $count++;
        }
    }

    echo "✅ {$count} personel eklendi!<br>";
    echo "✅ <a href='../personnel-attendance'>Personel Puantaj Sayfasına Git</a>";
} catch (Exception $e) {
    echo "❌ Hata: " . $e->getMessage();
}
