<?php
class PersonnelSalaryController {
    private $db;
    private $auth;

    public function __construct() {
        $this->db = Database::getInstance();
        $this->auth = new Auth();
    }

    public function index() {
        // Sadece admin erişebilir
        if ($this->auth->user()['role'] !== 'admin') {
            Helper::setFlash('Bu sayfaya erişim yetkiniz yok', 'danger');
            header('Location: ' . BASE_URL . '/dashboard');
            exit;
        }

        $selectedMonth = $_GET['month'] ?? date('Y-m');
        list($year, $month) = explode('-', $selectedMonth);

        // Puantaj ve ödeme bilgileriyle maaş hesapla
        $sql = "SELECT p.*,
                pa.calisan_gun, pa.yillik_izin, pa.pazar_gun,
                pa.gun_asiri_ek_mesai, pa.pazar_ek_mesai, pa.resmi_tatil_mesai,
                pa.yemek_gun, pa.ildisi_gun, pa.cep_masraf
                FROM personnel p
                LEFT JOIN personnel_attendance pa ON p.id = pa.personnel_id
                    AND pa.year = ? AND pa.month = ?
                WHERE p.is_active = 1
                ORDER BY p.full_name";

        $personnel = $this->db->select($sql, [$year, $month]);

        // Ayın toplam günü
        $totalDaysInMonth = cal_days_in_month(CAL_GREGORIAN, $month, $year);

        $salaryData = [];
        foreach ($personnel as $p) {
            $monthlySalary = $p['monthly_salary'] ?? 0;
            $dailyRate = $monthlySalary / $totalDaysInMonth; // Günlük ücret

            // Çalışma günü hesabı
            $calisanGun = $p['calisan_gun'] ?? 0;
            $yillikIzin = $p['yillik_izin'] ?? 0;
            $pazarGun = $p['pazar_gun'] ?? 0; // Manuel girilen pazar günü
            $totalWorkDays = $calisanGun + $yillikIzin;

            // Temel maaş hesabı için pazar günleri dahil
            $totalDaysForSalary = $totalWorkDays + $pazarGun;

            // Temel maaş (Geldiği gün + Manuel Pazar × Günlük ücret)
            $baseMaas = $totalDaysForSalary * $dailyRate;

            // Mesai hesaplamaları
            $gunAsiriMesai = $p['gun_asiri_ek_mesai'] ?? 0;
            $pazarMesai = $p['pazar_ek_mesai'] ?? 0;
            $resmiTatilMesai = $p['resmi_tatil_mesai'] ?? 0;

            $overtimeMultiplier = $p['overtime_multiplier'] ?? 1.00;
            $sundayMultiplier = $p['sunday_multiplier'] ?? 1.50;
            $holidayMultiplier = $p['holiday_multiplier'] ?? 1.00;

            // Mesai ücretleri
            $gunAsiriUcret = $gunAsiriMesai * $overtimeMultiplier * $dailyRate;
            $pazarMesaiUcret = $pazarMesai * $sundayMultiplier * $dailyRate;
            $resmiTatilUcret = $resmiTatilMesai * $holidayMultiplier * $dailyRate;

            $totalOvertimePay = $gunAsiriUcret + $pazarMesaiUcret + $resmiTatilUcret;

            // Yemek ücreti (Geldiği gün × Günlük yemek ücreti)
            $dailyMealFee = $p['daily_meal_fee'] ?? 0;
            $yemekUcret = $totalWorkDays * $dailyMealFee;

            // İlaveler
            $ildisiGun = ($p['ildisi_gun'] ?? 0) * 100; // Örnek: gün başı 100 TL
            $cepMasraf = $p['cep_masraf'] ?? 0;

            // Toplam hakediş
            $hakedis = $baseMaas + $totalOvertimePay + $yemekUcret + $ildisiGun + $cepMasraf;

            // Yapılan ödemeleri çek
            $payments = $this->db->select(
                "SELECT SUM(amount) as total FROM personnel_payments
                 WHERE personnel_id = ? AND YEAR(payment_date) = ? AND MONTH(payment_date) = ?
                 AND type IN ('advance', 'salary')",
                [$p['id'], $year, $month]
            );
            $odenen = $payments[0]['total'] ?? 0;

            $totalOvertime = $gunAsiriMesai + $pazarMesai + $resmiTatilMesai;

            $salaryData[] = [
                'id' => $p['id'],
                'full_name' => $p['full_name'],
                'monthly_salary' => $monthlySalary,
                'total_days' => $totalWorkDays, // Sadece gerçek çalışma günü göster
                'total_overtime' => $totalOvertime,
                'hakedis' => $hakedis,
                'odenen' => $odenen
            ];
        }

        $auth = $this->auth;
        $pageTitle = 'Personel Maaş Yönetimi';
        $currentPage = 'personnel-salary';
        require_once __DIR__ . '/../views/personnel/salary.php';
    }

    public function detail() {
        if ($this->auth->user()['role'] !== 'admin') {
            Helper::setFlash('Erişim yetkiniz yok', 'danger');
            header('Location: ' . BASE_URL . '/dashboard');
            exit;
        }

        $personnelId = $_GET['id'];
        $monthParam = $_GET['month'] ?? date('Y-m');
        list($year, $month) = explode('-', $monthParam);

        $personnel = $this->db->selectOne("SELECT * FROM personnel WHERE id = ?", [$personnelId]);

        // Bu ay ödemeleri
        $payments = $this->db->select(
            "SELECT * FROM personnel_payments
             WHERE personnel_id = ? AND YEAR(payment_date) = ? AND MONTH(payment_date) = ?
             ORDER BY payment_date DESC",
            [$personnelId, $year, $month]
        );

        // Tüm geçmiş
        $allPayments = $this->db->select(
            "SELECT * FROM personnel_payments WHERE personnel_id = ? ORDER BY payment_date DESC LIMIT 20",
            [$personnelId]
        );

        $auth = $this->auth;
        $pageTitle = 'Personel Maaş Detay';
        $currentPage = 'personnel-salary';
        require_once __DIR__ . '/../views/personnel/salary-detail.php';
    }

    public function addPayment() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'personnel_id' => $_POST['personnel_id'],
                'payment_date' => $_POST['payment_date'],
                'amount' => $_POST['amount'],
                'type' => $_POST['type'],
                'description' => $_POST['description']
            ];

            $this->db->insert('personnel_payments', $data);
            Helper::setFlash('Ödeme kaydedildi', 'success');

            $month = $_POST['month'] ?? date('Y-m');
            header('Location: ' . BASE_URL . '/personnel-salary/detail?id=' . $_POST['personnel_id'] . '&month=' . $month);
            exit;
        }
    }
}
