<?php
class PersonnelCardController {
    private $db;
    private $auth;

    public function __construct() {
        $this->db = Database::getInstance();
        $this->auth = new Auth();
    }

    public function generate() {
        $personnelId = $_GET['id'];
        $monthParam = $_GET['month'] ?? date('Y-m');
        list($year, $month) = explode('-', $monthParam);

        $personnel = $this->db->selectOne("SELECT * FROM personnel WHERE id = ?", [$personnelId]);
        $attendance = $this->db->selectOne(
            "SELECT * FROM personnel_attendance WHERE personnel_id = ? AND year = ? AND month = ?",
            [$personnelId, $year, $month]
        );

        $monthNames = ['','Ocak','Şubat','Mart','Nisan','Mayıs','Haziran','Temmuz','Ağustos','Eylül','Ekim','Kasım','Aralık'];
        $monthName = $monthNames[(int)$month];

        $auth = $this->auth;
        $pageTitle = 'Puantaj Kartı';
        $currentPage = 'personnel-attendance';
        require_once __DIR__ . '/../views/personnel/card.php';
    }
}
