<?php
class PersonnelAttendanceController {
    private $db;
    private $auth;

    public function __construct() {
        $this->db = Database::getInstance();
        $this->auth = new Auth();
    }

    public function index() {
        $selectedMonth = $_GET['month'] ?? date('Y-m');
        list($year, $month) = explode('-', $selectedMonth);

        $sql = "SELECT p.*,
                pa.calisan_gun, pa.yillik_izin, pa.pazar_gun,
                pa.gun_asiri_ek_mesai, pa.pazar_ek_mesai, pa.resmi_tatil_mesai,
                pa.yemek_gun, pa.ildisi_gun, pa.cep_masraf
                FROM personnel p
                LEFT JOIN personnel_attendance pa ON p.id = pa.personnel_id
                    AND pa.year = ? AND pa.month = ?
                WHERE p.is_active = 1
                ORDER BY p.full_name";

        $personnel = $this->db->select($sql, [$year, $month]);
        $auth = $this->auth;
        $pageTitle = 'Personel Puantaj';
        $currentPage = 'personnel-attendance';
        require_once __DIR__ . '/../views/personnel/attendance.php';
    }

    public function save() {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $period = explode('-', $_POST['period']);
            $data = [
                'personnel_id' => $_POST['personnel_id'],
                'year' => $period[0],
                'month' => $period[1],
                'calisan_gun' => $_POST['calisan_gun'] ?? 0,
                'yillik_izin' => $_POST['yillik_izin'] ?? 0,
                'pazar_gun' => $_POST['pazar_gun'] ?? 0,
                'gun_asiri_ek_mesai' => $_POST['gun_asiri_ek_mesai'] ?? 0,
                'pazar_ek_mesai' => $_POST['pazar_ek_mesai'] ?? 0,
                'resmi_tatil_mesai' => $_POST['resmi_tatil_mesai'] ?? 0,
                'yemek_gun' => $_POST['yemek_gun'] ?? 0,
                'ildisi_gun' => $_POST['ildisi_gun'] ?? 0,
                'cep_masraf' => $_POST['cep_masraf'] ?? 0,
                'created_by' => $this->auth->user()['id']
            ];

            $existing = $this->db->selectOne(
                "SELECT id FROM personnel_attendance WHERE personnel_id = ? AND year = ? AND month = ?",
                [$data['personnel_id'], $data['year'], $data['month']]
            );

            if ($existing) {
                $this->db->update('personnel_attendance', $data, ['id' => $existing['id']]);
            } else {
                $this->db->insert('personnel_attendance', $data);
            }

            Helper::setFlash('Puantaj kaydedildi', 'success');
            $redirectMonth = $data['year'] . '-' . str_pad($data['month'], 2, '0', STR_PAD_LEFT);
            header('Location: ' . BASE_URL . '/personnel-attendance?month=' . $redirectMonth);
            exit;
        }
    }

    public function edit() {
        $personnelId = $_GET['id'];
        $monthParam = $_GET['month'] ?? date('Y-m');
        list($year, $month) = explode('-', $monthParam);
        $month = (int)$month; // int'e çevir

        $personnel = $this->db->selectOne("SELECT * FROM personnel WHERE id = ?", [$personnelId]);
        $attendance = $this->db->selectOne(
            "SELECT * FROM personnel_attendance WHERE personnel_id = ? AND year = ? AND month = ?",
            [$personnelId, $year, $month]
        ) ?: []; // Boş array döndür eğer yoksa

        $auth = $this->auth;
        $pageTitle = 'Puantaj Düzenle';
        $currentPage = 'personnel-attendance';
        require_once __DIR__ . '/../views/personnel/edit.php';
    }
}
