<?php
class CreditCardController
{
    private $db;
    private $auth;

    public function __construct()
    {
        $this->db = Database::getInstance();
        $this->auth = new Auth();
    }

    public function index()
    {
        $cards = $this->db->select("SELECT *, (card_limit - current_debt) as available_limit FROM credit_cards ORDER BY card_name ASC");

        // Calculate summary
        $summary = [
            'total_limit' => 0,
            'total_debt' => 0,
            'available_limit' => 0
        ];

        foreach ($cards as $card) {
            $summary['total_limit'] += $card['card_limit'];
            $summary['total_debt'] += $card['current_debt'];
            $summary['available_limit'] += ($card['card_limit'] - $card['current_debt']);
        }

        $auth = $this->auth;
        $pageTitle = 'Kredi Kartları';
        $currentPage = 'credit-cards';
        require_once __DIR__ . '/../views/credit-cards/index.php';
    }

    public function create()
    {
        $auth = $this->auth;
        $pageTitle = 'Yeni Kredi Kartı Ekle';
        $currentPage = 'credit-cards';
        require_once __DIR__ . '/../views/credit-cards/create.php';
    }

    public function store()
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'bank_name' => $_POST['bank_name'] ?? '',
                'card_name' => $_POST['card_name'] ?? '',
                'card_number_last4' => $_POST['card_number_last4'] ?? '',
                'card_limit' => $_POST['card_limit'] ?? 0,
                'current_debt' => $_POST['current_debt'] ?? 0,
                'statement_day' => $_POST['statement_day'] ?? 1,
                'payment_due_day' => $_POST['payment_due_day'] ?? 10,
                'is_active' => isset($_POST['is_active']) ? 1 : 0
            ];

            $this->db->insert('credit_cards', $data);
            Helper::setFlash('success', 'Kredi kartı başarıyla eklendi.');
            header('Location: ' . BASE_URL . '/credit-cards');
            exit;
        }
    }

    public function edit($id)
    {
        $card = $this->db->selectOne("SELECT * FROM credit_cards WHERE id = :id", ['id' => $id]);
        if (!$card) {
            Helper::setFlash('danger', 'Kredi kartı bulunamadı.');
            header('Location: ' . BASE_URL . '/credit-cards');
            exit;
        }

        $auth = $this->auth;
        $pageTitle = 'Kredi Kartı Düzenle';
        $currentPage = 'credit-cards';
        require_once __DIR__ . '/../views/credit-cards/edit.php';
    }

    public function update($id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $statementDay = $_POST['statement_day'] ?? 1;

            // Hesap kesim tarihi otomatik hesapla (bu ay veya gelecek ay)
            $currentDay = date('j');
            $statementDate = null;
            if ($currentDay <= $statementDay) {
                // Bu ayın kesim günü henüz gelmediyse bu ay
                $statementDate = date('Y-m-') . str_pad($statementDay, 2, '0', STR_PAD_LEFT);
            } else {
                // Geçtiyse gelecek ay
                $statementDate = date('Y-m-', strtotime('+1 month')) . str_pad($statementDay, 2, '0', STR_PAD_LEFT);
            }

            $data = [
                'bank_name' => $_POST['bank_name'] ?? '',
                'card_name' => $_POST['card_name'] ?? '',
                'card_number_last4' => $_POST['card_number_last4'] ?? '',
                'card_limit' => $_POST['card_limit'] ?? 0,
                'current_debt' => $_POST['current_debt'] ?? 0,
                'statement_day' => $statementDay,
                'payment_due_day' => $_POST['payment_due_day'] ?? 10,
                'statement_amount' => $_POST['statement_amount'] ?? 0,
                'minimum_payment' => $_POST['minimum_payment'] ?? 0,
                'statement_date' => $statementDate, // Otomatik hesaplanan
                'due_date' => $_POST['due_date'] ?: null, // Manuel girilen veya null
                'is_active' => isset($_POST['is_active']) ? 1 : 0
            ];

            $this->db->update('credit_cards', $data, "id = $id");
            Helper::setFlash('success', 'Kredi kartı güncellendi.');
            header('Location: ' . BASE_URL . '/credit-cards');
            exit;
        }
    }

    public function delete($id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $this->db->delete('credit_cards', "id = $id");
            Helper::setFlash('success', 'Kredi kartı silindi.');
            header('Location: ' . BASE_URL . '/credit-cards');
            exit;
        }
    }

    public function addStatement($id)
    {
        $card = $this->db->selectOne("SELECT * FROM credit_cards WHERE id = :id", ['id' => $id]);
        if (!$card) {
            Helper::setFlash('danger', 'Kredi kartı bulunamadı.');
            header('Location: ' . BASE_URL . '/credit-cards');
            exit;
        }

        $auth = $this->auth;
        $pageTitle = 'Dönem Borcu Ekle';
        $currentPage = 'credit-cards';
        require_once __DIR__ . '/../views/credit-cards/add-statement.php';
    }

    public function storeStatement($id)
    {
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $data = [
                'card_id' => $id,
                'year' => $_POST['year'],
                'month' => $_POST['month'],
                'total_amount' => $_POST['total_amount'],
                'minimum_payment' => $_POST['minimum_payment'],
                'payment_status' => 'pending',
                'notes' => $_POST['notes'] ?? ''
            ];

            // Insert statement
            $this->db->insert('credit_card_payments', $data);

            // Update card current debt if requested
            if (isset($_POST['update_current_debt']) && $_POST['update_current_debt'] == 1) {
                $this->db->update('credit_cards', ['current_debt' => $data['total_amount']], "id = $id");
            }

            Helper::setFlash('success', 'Dönem borcu eklendi.');
            header('Location: ' . BASE_URL . '/credit-cards');
            exit;
        }
    }
}
