<?php
/**
 * ApiController - API Endpoints
 */

class ApiController {
    private $db;
    private $auth;

    public function __construct() {
        $this->db = Database::getInstance();
        $this->auth = new Auth();
    }

    public function handle($action, $id) {
        header('Content-Type: application/json');

        switch ($action) {
            case 'calendar-events':
                $this->calendarEvents();
                break;
            default:
                echo json_encode(['error' => 'Invalid endpoint']);
        }
    }

    private function calendarEvents() {
        // v_all_payments view'ından tüm ödemeleri çek
        $payments = $this->db->select("
            SELECT
                source,
                source_id,
                payment_date,
                payment_name,
                amount,
                status,
                category
            FROM v_all_payments
            WHERE payment_date IS NOT NULL
            ORDER BY payment_date ASC
        ");

        $events = [];

        foreach ($payments as $payment) {
            // Durum renklerini ayarla
            $color = match($payment['status']) {
                'paid' => '#28a745',      // Yeşil - Ödendi
                'pending' => '#ffc107',   // Sarı - Beklemede
                'overdue' => '#dc3545',   // Kırmızı - Gecikmiş
                default => '#6c757d'      // Gri - Diğer
            };

            $events[] = [
                'title' => $payment['payment_name'],
                'start' => $payment['payment_date'],
                'color' => $color,
                'extendedProps' => [
                    'amount' => Helper::formatMoney($payment['amount']),
                    'status' => Helper::translateStatus($payment['status']),
                    'category' => $payment['category'],
                    'source' => $payment['source']
                ]
            ];
        }

        // Kredi kartı hesap kesim ve son ödeme tarihlerini ekle
        $creditCards = $this->db->select("
            SELECT
                id,
                bank_name,
                card_name,
                statement_date,
                due_date,
                statement_amount,
                minimum_payment
            FROM credit_cards
            WHERE is_active = 1
            AND (statement_date IS NOT NULL OR due_date IS NOT NULL)
        ");

        foreach ($creditCards as $card) {
            $cardTitle = $card['bank_name'] . ' - ' . $card['card_name'];

            // Hesap kesim tarihi
            if ($card['statement_date']) {
                $events[] = [
                    'title' => '📊 Kesim: ' . $cardTitle,
                    'start' => $card['statement_date'],
                    'color' => '#17a2b8', // Mavi - Bilgi
                    'extendedProps' => [
                        'amount' => Helper::formatMoney($card['statement_amount'] ?? 0),
                        'status' => 'Hesap Kesim',
                        'category' => 'credit_card_statement',
                        'source' => 'credit_cards'
                    ]
                ];
            }

            // Son ödeme tarihi
            if ($card['due_date']) {
                $events[] = [
                    'title' => '💳 Ödeme: ' . $cardTitle,
                    'start' => $card['due_date'],
                    'color' => '#e83e8c', // Pembe - Kredi kartı
                    'extendedProps' => [
                        'amount' => 'Asgari: ' . Helper::formatMoney($card['minimum_payment'] ?? 0) . ' / Toplam: ' . Helper::formatMoney($card['statement_amount'] ?? 0),
                        'status' => 'Son Ödeme',
                        'category' => 'credit_card_payment',
                        'source' => 'credit_cards'
                    ]
                ];
            }
        }

        echo json_encode($events);
        exit;
    }
}
